/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.config.NarutoOriginsConfig;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ClanItemGiver
extends CommandBase {
    private final PlayerDataManager playerDataManager;

    public ClanItemGiver(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    public void giveClanItems(EntityPlayerMP player, MinecraftServer server) {
        String worldName;
        String playerName = player.func_70005_c_();
        PlayerData playerData = this.playerDataManager.getPlayerData(playerName, worldName = player.func_71121_q().func_72912_H().func_76065_j());
        String clan = playerData.getClan();
        if (clan != null && !clan.isEmpty()) {
            String commands = NarutoOriginsConfig.clanItems.get(clan.toLowerCase());
            if (commands != null && !commands.isEmpty()) {
                String[] commandArray;
                for (String cmd : commandArray = commands.split(";")) {
                    Item item;
                    if ((cmd = cmd.trim()).isEmpty()) continue;
                    String[] parts = cmd.split(" ");
                    String itemId = parts[0].trim();
                    int quantity = 1;
                    int meta = 0;
                    int nbtStartIndex = 2;
                    if (parts.length >= 2) {
                        try {
                            quantity = Integer.parseInt(parts[1].trim());
                            if (parts.length >= 3) {
                                try {
                                    meta = Integer.parseInt(parts[2].trim());
                                    nbtStartIndex = 3;
                                }
                                catch (NumberFormatException e2) {
                                    nbtStartIndex = 2;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            nbtStartIndex = 1;
                        }
                    }
                    if ((item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId))) != null) {
                        boolean added;
                        ItemStack itemStack = new ItemStack(item, quantity, meta);
                        if (parts.length > nbtStartIndex) {
                            StringBuilder nbtBuilder = new StringBuilder();
                            for (int i = nbtStartIndex; i < parts.length; ++i) {
                                nbtBuilder.append(parts[i]).append(" ");
                            }
                            String nbtString = nbtBuilder.toString().trim();
                            if (nbtString.matches("\\{Type:snake\\}")) {
                                nbtString = "{Type:\"snake\"}";
                            } else if (nbtString.matches("\\{Type:enma\\}")) {
                                nbtString = "{Type:\"enma\"}";
                            }
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "NBT raw input: " + nbtString));
                            try {
                                NBTTagCompound tag = JsonToNBT.func_180713_a((String)nbtString);
                                itemStack.func_77982_d(tag);
                            }
                            catch (NBTException e) {
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid NBT data: " + nbtString));
                            }
                        }
                        if (added = player.field_71071_by.func_70441_a(itemStack)) continue;
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Inventory full, could not add: " + itemId));
                        continue;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid item ID: " + itemId));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No clan items selected"));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You're not in a clan >-<"));
        }
    }

    public String func_71517_b() {
        return "giveClanItems";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/giveClanItems <playerName>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
            if (player == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Player not found: " + args[0]));
                return;
            }
            this.giveClanItems(player, server);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Clan items have been given to " + args[0] + "!"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: /giveClanItems <playerName>"));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return ClanItemGiver.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return new ArrayList<String>();
    }
}

