/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.ClanAdvancementAssigner;
import com.tyler.narutoorigin.coremod.ClanEffectManager;
import com.tyler.narutoorigin.coremod.CommandSimulate;
import com.tyler.narutoorigin.coremod.ContractAssigner;
import com.tyler.narutoorigin.coremod.DojutsuAdvancementAssigner;
import com.tyler.narutoorigin.coremod.KKGAdvancementAssigner;
import com.tyler.narutoorigin.coremod.MedicAdvancementAssigner;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import com.tyler.narutoorigin.coremod.SenjutsuAssigner;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandClaimOrigin
extends CommandBase {
    private final CommandSimulate simulateCommand;
    private final PlayerDataManager playerDataManager;
    private final KKGAdvancementAssigner kkgAdvancementAssigner;
    private final DojutsuAdvancementAssigner dojutsuAdvancementAssigner;
    private final MedicAdvancementAssigner medicAdvancementAssigner;
    private final ClanAdvancementAssigner clanAdvancementAssigner;
    private final ContractAssigner contractAssigner;
    private final SenjutsuAssigner senjutsuAssigner;
    private final String[] restrictedAdvancements = new String[]{"narutomod:mokuton_acquired", "narutomod:bakuton_acquired", "narutomod:futton_acquired", "narutomod:hyoton_acquired", "narutomod:jiton_acquired", "narutomod:kekkei_tota_awakened", "narutomod:ranton_acquired", "narutomod:shakuton_acquired", "narutomod:shikotsumyaku_acquired", "narutomod:yooton_acquired", "narutomod:rinneganawakened", "narutomod:byakuganopened", "narutomod:sharinganopened"};
    private static final String[] HEADBANDS = new String[]{"narutomod:ninja_armor_kirihelmet", "narutomod:ninja_armor_sunahelmet", "narutomod:ninja_armor_kumohelmet", "narutomod:ninja_armor_konohahelmet", "narutomod:ninja_armor_amehelmet", "narutomod:ninja_armor_jiraiyahelmet"};

    public CommandClaimOrigin(CommandSimulate simulateCommand, PlayerDataManager playerDataManager, KKGAdvancementAssigner kkgAdvancementAssigner, DojutsuAdvancementAssigner dojutsuAdvancementAssigner, MedicAdvancementAssigner medicAdvancementAssigner, ClanAdvancementAssigner clanAdvancementAssigner, ContractAssigner contractAssigner, SenjutsuAssigner senjutsuAssigner) {
        this.simulateCommand = simulateCommand;
        this.playerDataManager = playerDataManager;
        this.kkgAdvancementAssigner = kkgAdvancementAssigner;
        this.dojutsuAdvancementAssigner = dojutsuAdvancementAssigner;
        this.medicAdvancementAssigner = medicAdvancementAssigner;
        this.clanAdvancementAssigner = clanAdvancementAssigner;
        this.contractAssigner = contractAssigner;
        this.senjutsuAssigner = senjutsuAssigner;
    }

    public String func_71517_b() {
        return "claimOrigin";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/claimOrigin <index>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        int index;
        if (!(sender instanceof EntityPlayerMP)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This command can only be used by players."));
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        String playerName = player.func_70005_c_();
        String worldName = player.func_71121_q().func_72912_H().func_76065_j();
        PlayerData playerData = this.playerDataManager.getPlayerData(playerName, worldName);
        if (this.hasRestrictedAdvancement(player)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "It is too late to claim an Origin now."));
            return;
        }
        if (playerData.hasClaimedOrigin()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have already claimed an Origin."));
            return;
        }
        if (args.length < 1) {
            throw new WrongUsageException("Usage: /claimOrigin <index>", new Object[0]);
        }
        try {
            index = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("The index must be a valid number.", new Object[0]);
        }
        String[] claimData = this.simulateCommand.getPendingClaim(playerName, index);
        if (claimData == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid origin selection."));
            return;
        }
        this.claimOrigin(player, claimData);
        this.simulateCommand.clearPendingClaims(playerName);
    }

    public void claimOrigin(final EntityPlayerMP player, String[] claimData) {
        String playerName = player.func_70005_c_();
        String worldName = player.func_71121_q().func_72912_H().func_76065_j();
        final PlayerData playerData = this.playerDataManager.getPlayerData(playerName, worldName);
        playerData.setClan(claimData[0]);
        String bonusKkg = claimData.length > 8 ? claimData[8] : "no Bonus KKG";
        String finalKkg = claimData[3];
        if (!bonusKkg.equals("no Bonus KKG")) {
            finalKkg = finalKkg.equals("no KKG") || finalKkg.isEmpty() ? bonusKkg : finalKkg + "," + bonusKkg;
        }
        playerData.setKkg(finalKkg);
        playerData.setDojutsu(claimData[1]);
        playerData.setHasClaimedOrigin(true);
        this.playerDataManager.savePlayerData(playerData);
        if (claimData[0] != null && !claimData[0].equalsIgnoreCase("no Clan")) {
            this.clanAdvancementAssigner.assignClanAdvancement(player);
        }
        ClanEffectManager.applyEffectsBasedOnClan(player, playerData.getClan());
        final MinecraftServer server = player.func_184102_h();
        if (server != null) {
            if (!finalKkg.equals("no KKG")) {
                this.kkgAdvancementAssigner.assignKKGAdvancement(player);
            }
            this.contractAssigner.assignContract(player, claimData);
            if (!claimData[1].equals("no Dojutsu")) {
                this.dojutsuAdvancementAssigner.assignDojutsuAdvancement(player);
            }
            if (claimData[5] != null && claimData[5].equalsIgnoreCase("Medic")) {
                this.medicAdvancementAssigner.assignMedicAdvancement(player, claimData);
            }
            if (!claimData[2].equals("no Element")) {
                server.func_71187_D().func_71556_a((ICommandSender)server, "/executeElement " + playerName + " " + claimData[2].toLowerCase());
            }
            if (!claimData[6].isEmpty()) {
                server.func_71187_D().func_71556_a((ICommandSender)server, "/executeTailedBeast " + playerName + " " + claimData[6]);
            }
            if (!claimData[7].equals("no Senjutsu")) {
                this.senjutsuAssigner.assignSenjutsu(player, claimData[7]);
            }
            this.giveRandomHeadband(player);
            this.applyChakraRegenEffect(server, player);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have claimed your Origin successfully."));
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    server.func_152344_a(() -> {
                        server.func_71187_D().func_71556_a((ICommandSender)player, "resetMe");
                        playerData.setHasUsedResetMe(true);
                        CommandClaimOrigin.this.playerDataManager.savePlayerData(playerData);
                    });
                }
            }, 300L);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    server.func_152344_a(() -> {
                        server.func_71187_D().func_71556_a((ICommandSender)player, "makeMeAShinobi");
                        timer.cancel();
                    });
                }
            }, 600L);
        }
    }

    private boolean hasRestrictedAdvancement(EntityPlayerMP player) {
        for (String advancementId : this.restrictedAdvancements) {
            AdvancementProgress progress;
            Advancement advancement = player.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation(advancementId));
            if (advancement == null || !(progress = player.func_192039_O().func_192747_a(advancement)).func_192105_a()) continue;
            return true;
        }
        return false;
    }

    private void executeServerCommand(MinecraftServer server, ICommandSender sender, String command) {
        server.func_71187_D().func_71556_a(sender, command);
    }

    private void giveRandomHeadband(EntityPlayerMP player) {
        ItemStack stack;
        Random random = new Random();
        String itemId = HEADBANDS[random.nextInt(HEADBANDS.length)];
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId));
        if (item != null && !player.field_71071_by.func_70441_a(stack = new ItemStack(item, 1, 0))) {
            player.func_71019_a(stack, false);
        }
    }

    private void applyChakraRegenEffect(MinecraftServer server, EntityPlayerMP player) {
        this.executeServerCommand(server, (ICommandSender)server, "effect " + player.func_70005_c_() + " narutomod:chakra_regeneration 10");
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }
}

