/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandResetMe
extends CommandBase {
    private final PlayerDataManager playerDataManager;

    public CommandResetMe(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    public String func_71517_b() {
        return "resetMe";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/resetMe";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File inventoryFile;
        EntityPlayerMP player;
        if (sender instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)sender;
            String playerName = player.func_70005_c_();
            File saveDirectory = new File(player.func_71121_q().func_72860_G().func_75765_b(), "playerInvDataDoNotDelete");
            if (!saveDirectory.exists()) {
                if (saveDirectory.mkdirs()) {
                    System.out.println("Directory 'playerInvDataDoNotDelete' has been created.");
                } else {
                    throw new CommandException("Failed to create inventory storage directory.", new Object[0]);
                }
            }
            if ((inventoryFile = new File(saveDirectory, playerName + "_inventory.dat")).exists()) {
                throw new CommandException("You have already reset your inventory and cannot do so again.", new Object[0]);
            }
        } else {
            throw new CommandException("This command can only be executed by a player.", new Object[0]);
        }
        this.savePlayerInventoryToNBT(player, inventoryFile);
        player.field_71071_by.func_174888_l();
    }

    private void savePlayerInventoryToNBT(EntityPlayerMP player, File inventoryFile) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            stack.func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagList armorTagList = new NBTTagList();
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i + 100);
            stack.func_77955_b(itemTag);
            armorTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound inventoryData = new NBTTagCompound();
        inventoryData.func_74782_a("Inventory", (NBTBase)nbtTagList);
        inventoryData.func_74782_a("Armor", (NBTBase)armorTagList);
        try (FileOutputStream fos = new FileOutputStream(inventoryFile);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)inventoryData, (OutputStream)fos);
        }
        catch (IOException e) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to save your inventory."));
            e.printStackTrace();
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public static void restorePlayerInventory(EntityPlayerMP player) {
        File saveDirectory = new File(player.func_71121_q().func_72860_G().func_75765_b(), "playerInvDataDoNotDelete");
        File inventoryFile = new File(saveDirectory, player.func_70005_c_() + "_inventory.dat");
        if (!inventoryFile.exists()) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No inventory found to restore."));
            return;
        }
        try (FileInputStream fis = new FileInputStream(inventoryFile);){
            NBTTagCompound inventoryData = CompressedStreamTools.func_74796_a((InputStream)fis);
            NBTTagList nbtTagList = inventoryData.func_150295_c("Inventory", 10);
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = nbtTagList.func_150305_b(i);
                ItemStack stack = new ItemStack(itemTag);
                player.field_71071_by.func_70441_a(stack);
            }
            NBTTagList armorTagList = inventoryData.func_150295_c("Armor", 10);
            for (int i = 0; i < armorTagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = armorTagList.func_150305_b(i);
                ItemStack stack = new ItemStack(itemTag);
                player.field_71071_by.func_70441_a(stack);
            }
            if (inventoryFile.delete()) {
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to delete the inventory file after restoring."));
            }
        }
        catch (IOException e) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to restore your inventory."));
            e.printStackTrace();
        }
    }
}

