/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.narutomod.PlayerTracker;

public class CommandSetNinjaXp
extends CommandBase {
    public String func_71517_b() {
        return "setNinjaXp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/setNinjaXp <player> <xp> - Sets the Ninja XP (Battle XP) of the specified player.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        double newXp;
        if (args.length != 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /setNinjaXp <player> <xp>"));
            return;
        }
        String playerName = args[0];
        try {
            newXp = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid XP value. Please enter a valid number."));
            return;
        }
        EntityPlayerMP targetPlayer = server.func_184103_al().func_152612_a(playerName);
        if (targetPlayer == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Player '" + playerName + "' not found."));
            return;
        }
        PlayerTracker.addBattleXp((EntityPlayer)targetPlayer, (double)newXp);
        sender.func_145747_a((ITextComponent)new TextComponentString("Set Ninja XP for player '" + playerName + "' to " + newXp + "."));
        targetPlayer.func_145747_a((ITextComponent)new TextComponentString("Your Ninja XP has been set to " + newXp + " by an admin."));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandSetNinjaXp.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return new ArrayList<String>();
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, this.func_71517_b());
    }
}

