/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.narutomod.Chakra;

public class CommandShowChakraRegenRatja
extends CommandBase {
    private final PlayerDataManager playerDataManager;

    public CommandShowChakraRegenRatja(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    public String func_71517_b() {
        return "showChakraRegen";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/showChakraRegen <player>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, this.func_71517_b());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        double baseRegenRate;
        if (args.length != 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: /showChakraRegen <player>"));
            return;
        }
        String playerName = args[0];
        EntityPlayerMP targetPlayer = server.func_184103_al().func_152612_a(playerName);
        if (targetPlayer == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Player not found: " + playerName));
            return;
        }
        PlayerData playerData = this.playerDataManager.getPlayerData(targetPlayer.func_70005_c_(), targetPlayer.func_71121_q().func_72912_H().func_76065_j());
        if (playerData == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Player data not available for: " + playerName));
            return;
        }
        Chakra.PathwayPlayer pathway = Chakra.pathway((EntityPlayer)targetPlayer);
        if (pathway == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Chakra pathway not initialized for player: " + playerName));
            return;
        }
        double effectiveRegenRate = baseRegenRate = 0.006;
        if ("Ghost".equalsIgnoreCase(playerData.getClan())) {
            effectiveRegenRate *= 5.0;
        }
        double regenPerSecond = effectiveRegenRate * 20.0;
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Player " + playerName + "'s Chakra Regeneration Rate: " + TextFormatting.AQUA + String.format("%.3f per second", regenPerSecond)));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandShowChakraRegenRatja.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }
}

