/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.config.NarutoOriginsConfig;
import com.tyler.narutoorigin.coremod.ChatOrigin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandSimulate
extends CommandBase {
    private final Random rand = new Random();
    private final Map<String, Boolean> hasClaimedOrigin = new HashMap<String, Boolean>();
    private final Map<String, Integer> simulationCount = new HashMap<String, Integer>();
    private final Map<String, List<String[]>> pendingClaims = new HashMap<String, List<String[]>>();
    private final Map<String, Set<String>> usedClans = new HashMap<String, Set<String>>();
    private final String[] element = new String[]{"fire", "water", "earth", "lightning", "wind"};
    private final String dustKKG = "Dust";
    private final String[] dojutsu = new String[]{"Sharingan", "Byakugan", "no Dojutsu"};
    private final String[] medic = new String[]{"Medic"};
    private final String[] tailedBeasts = new String[]{"Shukaku", "Matatabi", "Isobu", "Son Goku", "Kokuo", "Saiken", "Chomei", "Gyuki", "Kurama"};
    private final String[] monkeyClan = new String[]{"Monkey"};
    private final String[] ghostClan = new String[]{"Ghost"};
    private final String[] taijutsu = new String[]{""};
    private final String[] restrictedAdvancements = new String[]{"narutomod:mokuton_acquired", "narutomod:bakuton_acquired", "narutomod:futton_acquired", "narutomod:hyoton_acquired", "narutomod:jiton_acquired", "narutomod:kekkei_tota_awakened", "narutomod:ranton_acquired", "narutomod:shakuton_acquired", "narutomod:shikotsumyaku_acquired", "narutomod:yooton_acquired", "narutomod:rinneganawakened", "narutomod:byakuganopened", "narutomod:sharinganopened"};

    public String func_71517_b() {
        return "simulate";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simulate";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        String[] contracts;
        String[] senjutsuTypes;
        if (!(sender instanceof EntityPlayerMP)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This command can only be used by players."));
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        String playerName = player.func_70005_c_();
        if (this.hasRestrictedAdvancement(player)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "It is too late to simulate now."));
            return;
        }
        if (this.hasPlayerClaimedOrigin(playerName)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have already claimed an Origin."));
            return;
        }
        int maxSimulations = NarutoOriginsConfig.maxSimulations;
        if (this.simulationCount.getOrDefault(playerName, 0) >= maxSimulations) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have reached the maximum number of simulations (" + maxSimulations + ")."));
            return;
        }
        Set playerUsedClans = this.usedClans.getOrDefault(playerName, new HashSet());
        ArrayList<String> availableClans = new ArrayList<String>(Arrays.asList(NarutoOriginsConfig.simulateableClans));
        availableClans.removeAll(playerUsedClans);
        if (NarutoOriginsConfig.monkeyClan) {
            availableClans.addAll(Arrays.asList(this.monkeyClan));
        }
        if (NarutoOriginsConfig.ghostClan) {
            availableClans.addAll(Arrays.asList(this.ghostClan));
        }
        if (availableClans.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No more clans available to simulate."));
            return;
        }
        String selectedClan = (String)availableClans.get(this.rand.nextInt(availableClans.size()));
        playerUsedClans.add(selectedClan);
        this.usedClans.put(playerName, playerUsedClans);
        String selectedDojutsu = "no Dojutsu";
        String selectedElement = "no Element";
        String selectedKKG = "no KKG";
        String selectedBonusKKG = "no Bonus KKG";
        switch (selectedClan) {
            case "Uchiha": {
                selectedDojutsu = "Sharingan";
                selectedElement = "fire";
                if (NarutoOriginsConfig.onlyDojutsuNoKKG && !selectedDojutsu.equals("no Dojutsu")) break;
                selectedKKG = this.getRandomKKG();
                break;
            }
            case "Hyuga": {
                selectedDojutsu = "Byakugan";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                if (NarutoOriginsConfig.onlyDojutsuNoKKG && !selectedDojutsu.equals("no Dojutsu")) break;
                selectedKKG = this.getRandomKKG();
                break;
            }
            case "Otsutsuki": {
                float dojutsuRoll = this.rand.nextFloat() * 100.0f;
                selectedDojutsu = dojutsuRoll < NarutoOriginsConfig.otsutsukiByakuganProbability * 100.0f ? "Byakugan" : "Sharingan";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                if (NarutoOriginsConfig.onlyDojutsuNoKKG && !selectedDojutsu.equals("no Dojutsu")) break;
                selectedKKG = this.getRandomKKG();
                break;
            }
            case "Senju": {
                selectedDojutsu = "no Dojutsu";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                selectedKKG = this.getRandomKKG();
                if (!((float)this.rand.nextInt(100) < NarutoOriginsConfig.senjuWoodKKGProbability * 100.0f)) break;
                selectedBonusKKG = "Wood";
                break;
            }
            case "Terumi": {
                selectedKKG = this.rand.nextInt(100) < 50 ? "Lava" : "Boil";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                break;
            }
            case "Kaguya": {
                selectedDojutsu = "no Dojutsu";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                selectedKKG = "shikotsumyaku";
                break;
            }
            case "Kamikaze": {
                selectedKKG = "Explosion";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                break;
            }
            case "Kazesuna": {
                selectedKKG = "Magnet";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                break;
            }
            default: {
                selectedDojutsu = "no Dojutsu";
                selectedElement = this.element[this.rand.nextInt(this.element.length)];
                selectedKKG = this.getRandomKKG();
            }
        }
        if (selectedDojutsu.equals("no Dojutsu") && NarutoOriginsConfig.allowKetsuAsRandomDojutsu && this.rand.nextFloat() < NarutoOriginsConfig.ketsuryuganProbability) {
            selectedDojutsu = "Ketsuryugan";
        }
        String selectedTaijutsu = this.taijutsu[this.rand.nextInt(this.taijutsu.length)];
        String selectedMedic = (float)this.rand.nextInt(100) < NarutoOriginsConfig.medicProbability * 100.0f ? "Medic" : "no Medic";
        String selectedTailedBeast = "";
        if ((float)this.rand.nextInt(100) < NarutoOriginsConfig.tailedBeastProbability * 100.0f) {
            selectedTailedBeast = this.tailedBeasts[this.rand.nextInt(this.tailedBeasts.length)];
        }
        String selectedSenjutsu = "no Senjutsu";
        if (this.rand.nextFloat() < NarutoOriginsConfig.senjutsuProbability && (senjutsuTypes = NarutoOriginsConfig.simulateableSenjutsu) != null && senjutsuTypes.length > 0) {
            selectedSenjutsu = senjutsuTypes[this.rand.nextInt(senjutsuTypes.length)];
        }
        String selectedContract = "no Contract";
        if (this.rand.nextFloat() < NarutoOriginsConfig.contractProbability && (contracts = NarutoOriginsConfig.simulateableContracts) != null && contracts.length > 0) {
            selectedContract = contracts[this.rand.nextInt(contracts.length)];
        }
        String[] newSimulationResult = new String[]{selectedClan, selectedDojutsu, selectedElement, selectedKKG, selectedTaijutsu, selectedMedic, selectedTailedBeast, selectedSenjutsu, selectedBonusKKG, selectedContract};
        this.pendingClaims.putIfAbsent(playerName, new ArrayList());
        this.pendingClaims.get(playerName).add(newSimulationResult);
        this.simulationCount.put(playerName, this.simulationCount.getOrDefault(playerName, 0) + 1);
        if (player != null) {
            ChatOrigin.displayOriginSelection(player, server, newSimulationResult, this.simulationCount.get(playerName) - 1);
        }
    }

    private boolean hasRestrictedAdvancement(EntityPlayerMP player) {
        for (String advancementId : this.restrictedAdvancements) {
            AdvancementProgress progress;
            Advancement advancement = player.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation(advancementId));
            if (advancement == null || !(progress = player.func_192039_O().func_192747_a(advancement)).func_192105_a()) continue;
            return true;
        }
        return false;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean hasPlayerClaimedOrigin(String playerName) {
        return this.hasClaimedOrigin.getOrDefault(playerName, false);
    }

    public void setPlayerClaimedOrigin(String playerName) {
        this.hasClaimedOrigin.put(playerName, true);
    }

    public List<String[]> getPendingClaims(String playerName) {
        return this.pendingClaims.getOrDefault(playerName, new ArrayList());
    }

    public String[] getPendingClaim(String playerName, int index) {
        List<String[]> claims = this.getPendingClaims(playerName);
        if (index >= 0 && index < claims.size()) {
            return claims.get(index);
        }
        return null;
    }

    public void clearPendingClaims(String playerName) {
        this.pendingClaims.remove(playerName);
    }

    private String getRandomKKG() {
        ArrayList<String> availableKKGs = new ArrayList<String>(Arrays.asList(NarutoOriginsConfig.simulateableKKGs));
        if (NarutoOriginsConfig.enableDustKKG) {
            availableKKGs.add("Dust");
        }
        return (String)availableKKGs.get(this.rand.nextInt(availableKKGs.size()));
    }

    public void resetSimulations(String playerName) {
        this.simulationCount.remove(playerName);
        this.pendingClaims.remove(playerName);
        this.usedClans.remove(playerName);
    }
}

