/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class DojutsuAdvancementAssigner {
    private final PlayerDataManager playerDataManager;
    private final MinecraftServer server;

    public DojutsuAdvancementAssigner(PlayerDataManager playerDataManager, MinecraftServer server) {
        this.playerDataManager = playerDataManager;
        this.server = server;
    }

    public void assignDojutsuAdvancement(EntityPlayerMP player) {
        String worldName;
        String playerName = player.func_70005_c_();
        PlayerData playerData = this.playerDataManager.getPlayerData(playerName, worldName = player.func_71121_q().func_72912_H().func_76065_j());
        String dojutsu = playerData.getDojutsu();
        if (dojutsu != null && !dojutsu.equals("no Dojutsu") && !dojutsu.isEmpty() && this.server != null) {
            switch (dojutsu.toLowerCase()) {
                case "sharingan": {
                    this.server.func_71187_D().func_71556_a((ICommandSender)this.server, "advancement grant " + playerName + " only narutomod:sharinganopened");
                    break;
                }
                case "byakugan": {
                    this.server.func_71187_D().func_71556_a((ICommandSender)this.server, "advancement grant " + playerName + " only narutomod:byakuganopened");
                    break;
                }
                case "rinnegan": {
                    this.server.func_71187_D().func_71556_a((ICommandSender)this.server, "advancement grant " + playerName + " only narutomod:rinneganawakened");
                    break;
                }
                case "ketsuryugan": {
                    this.server.func_71187_D().func_71556_a((ICommandSender)this.server, "advancement grant " + playerName + " only ahznbcursemarkaddon:ketsuryuganopened");
                    this.giveKetsuItemWithOwnerNBT(player, "ahznbcursemarkaddon:ketsuryuganoffhelmet", "Ketsuryugan");
                    break;
                }
                default: {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown Dojutsu type: " + dojutsu));
                    return;
                }
            }
        }
    }

    private void giveKetsuItemWithOwnerNBT(EntityPlayerMP player, String itemId, String dojutsuName) {
        Item item = Item.func_111206_d((String)itemId);
        if (item == null) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown item id: " + itemId));
            return;
        }
        ItemStack stack = new ItemStack(item, 1);
        UUID uuid = player.func_110124_au();
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        tag.func_74772_a("player_idLeast", uuid.getLeastSignificantBits());
        tag.func_74772_a("player_idMost", uuid.getMostSignificantBits());
        NBTTagCompound display = tag.func_150297_b("display", 10) ? tag.func_74775_l("display") : new NBTTagCompound();
        String name = "\u00a7f" + player.func_70005_c_() + "'s \u00a7c" + dojutsuName + "\u00a7r";
        display.func_74778_a("Name", name);
        tag.func_74782_a("display", (NBTBase)display);
        stack.func_77982_d(tag);
        if (!player.func_191521_c(stack)) {
            player.func_70099_a(stack, 0.0f);
        }
    }
}

