/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.narutomod.Chakra;

public class GhostClanChakraRegenerationRatja {
    private final PlayerDataManager playerDataManager;
    private static final List<String> ELIGIBLE_CLANS = Arrays.asList("Ghost", "King");

    public GhostClanChakraRegenerationRatja(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        double maxChakra;
        if (event.phase != TickEvent.Phase.END || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerData playerData = this.playerDataManager.getPlayerData(player.func_70005_c_(), player.field_70170_p.func_72912_H().func_76065_j());
        if (playerData == null) {
            System.err.println("PlayerData not found for player: " + player.func_70005_c_());
            return;
        }
        String clan = playerData.getClan();
        if (!ELIGIBLE_CLANS.contains(clan)) {
            return;
        }
        Chakra.PathwayPlayer pathway = Chakra.pathway((EntityPlayer)player);
        if (pathway == null) {
            System.err.println("Failed to retrieve Chakra pathway for player: " + player.func_70005_c_());
            return;
        }
        double currentChakra = pathway.getAmount();
        if (currentChakra < (maxChakra = pathway.getMax()) * 0.25 && player.field_70173_aa % 200 == 0) {
            double regenAmount = maxChakra * 0.15;
            pathway.consume(-regenAmount);
            System.out.println("Regenerated " + regenAmount + " chakra for player: " + player.func_70005_c_() + " (" + clan + ")");
        }
    }
}

