/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.config.NarutoOriginsConfig;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class KKGAdvancementAssigner {
    private final PlayerDataManager playerDataManager;
    private final MinecraftServer server;

    public KKGAdvancementAssigner(PlayerDataManager playerDataManager, MinecraftServer server) {
        this.playerDataManager = playerDataManager;
        this.server = server;
    }

    public void assignKKGAdvancement(EntityPlayerMP player) {
        String worldName;
        String playerName = player.func_70005_c_();
        PlayerData playerData = this.playerDataManager.getPlayerData(playerName, worldName = player.func_71121_q().func_72912_H().func_76065_j());
        String kkg = playerData.getKkg();
        if (kkg != null && !kkg.equals("no KKG") && !kkg.isEmpty() && this.server != null) {
            String[] kkgs;
            for (String part : kkgs = kkg.split(",")) {
                String key = part.trim().toLowerCase(Locale.ROOT);
                NarutoOriginsConfig.KKGMapping map = NarutoOriginsConfig.kkgMappings.get(key);
                if (map == null) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown KKG type: " + part));
                    continue;
                }
                this.server.func_71187_D().func_71556_a((ICommandSender)this.server, "advancement grant " + playerName + " from " + map.advancementId);
                String itemId = map.itemId;
                if (itemId == null || itemId.isEmpty() || itemId.startsWith("narutomod:")) continue;
                Item item = Item.func_111206_d((String)itemId);
                if (item == null) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown item id: " + itemId));
                    continue;
                }
                ItemStack stack = new ItemStack(item, 1);
                if (player.func_191521_c(stack)) continue;
                player.func_70099_a(stack, 0.0f);
            }
        }
    }
}

