/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KingCrownLifestealRatja {
    private final PlayerDataManager playerDataManager;
    private static final List<String> ELIGIBLE_CLANS = Arrays.asList("King", "Crooked_Crown");

    public KingCrownLifestealRatja(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP attacker = (EntityPlayerMP)event.getEntity();
        PlayerData attackerData = this.playerDataManager.getPlayerData(attacker.func_70005_c_(), attacker.field_70170_p.func_72912_H().func_76065_j());
        if (attackerData == null || !ELIGIBLE_CLANS.contains(attackerData.getClan())) {
            return;
        }
        if (!(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)event.getTarget();
        float attackDamage = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float damage = attacker.func_184825_o(0.5f) * attackDamage;
        float lifestealAmount = damage * 0.1f;
        float extraHealing = 4.0f;
        float totalHeal = lifestealAmount + extraHealing;
        float maxHealth = attacker.func_110138_aP();
        float currentHealth = attacker.func_110143_aJ();
        if (currentHealth + totalHeal > maxHealth) {
            float overheal = currentHealth + totalHeal - maxHealth;
            attacker.func_70691_i(maxHealth - currentHealth);
            attacker.func_110149_m(attacker.func_110139_bj() + overheal);
        } else {
            attacker.func_70691_i(totalHeal);
        }
    }
}

