/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.CommandSimulate;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class OriginsRemover
extends CommandBase {
    private final PlayerDataManager playerDataManager;
    private final CommandSimulate simulateCommand;

    public OriginsRemover(PlayerDataManager playerDataManager, CommandSimulate simulateCommand) {
        this.playerDataManager = playerDataManager;
        this.simulateCommand = simulateCommand;
    }

    public String func_71517_b() {
        return "removeOrigin";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/removeOrigin <playername> - Removes the NarutoOrigins player data and specific achievements of the specified player.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException("Usage: /removeOrigin <playername>", new Object[0]);
        }
        String targetPlayerName = args[0];
        String playerKey = targetPlayerName + ":" + server.func_71218_a(0).func_72912_H().func_76065_j();
        Map<String, PlayerData> playerDataMap = this.playerDataManager.getPlayerDataMap();
        if (playerDataMap.containsKey(playerKey)) {
            playerDataMap.remove(playerKey);
            this.playerDataManager.savePlayerDataToFile();
            this.playerDataManager.loadPlayerData();
            EntityPlayerMP targetPlayer = server.func_184103_al().func_152612_a(targetPlayerName);
            List<Object> removedAchievements = new ArrayList();
            if (targetPlayer != null) {
                removedAchievements = this.removeAchievements(targetPlayer, server);
            }
            this.simulateCommand.resetSimulations(targetPlayerName);
            sender.func_145747_a((ITextComponent)new TextComponentString("Simulations reset for " + targetPlayerName + "."));
            String removedAchievementsText = removedAchievements.isEmpty() ? "" : " (" + String.join((CharSequence)"; ", removedAchievements) + ")";
            sender.func_145747_a((ITextComponent)new TextComponentString("NarutoOrigins player data for " + targetPlayerName + " has been successfully deleted." + removedAchievementsText));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("No NarutoOrigins player data found for " + targetPlayerName + "."));
        }
    }

    private List<String> removeAchievements(EntityPlayerMP player, MinecraftServer server) {
        String[] achievementsToRemove = new String[]{"narutomod:mokuton_acquired", "narutomod:bakuton_acquired", "narutomod:futton_acquired", "narutomod:hyoton_acquired", "narutomod:jiton_acquired", "narutomod:kekkei_tota_awakened", "narutomod:ranton_acquired", "narutomod:shakuton_acquired", "narutomod:shikotsumyaku_acquired", "narutomod:yooton_acquired", "narutomod:rinneganawakened", "narutomod:byakuganopened", "narutomod:sharinganopened"};
        ArrayList<String> removedAchievements = new ArrayList<String>();
        for (String achievementKey : achievementsToRemove) {
            ResourceLocation achievementResource = new ResourceLocation(achievementKey);
            Advancement advancement = server.func_191949_aK().func_192778_a(achievementResource);
            if (advancement == null || !player.func_192039_O().func_192747_a(advancement).func_192105_a()) continue;
            player.func_192039_O().func_192747_a(advancement).func_192102_e().forEach(criterion -> player.func_192039_O().func_192744_b(advancement, criterion));
            removedAchievements.add(achievementKey.substring(achievementKey.lastIndexOf(":") + 1));
        }
        return removedAchievements;
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return OriginsRemover.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }
}

