/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PermaDeath
extends CommandBase {
    public static boolean permadeathEnabled = false;
    private static boolean countdownActive = false;
    private static final List<TickTask> tickTasks = new ArrayList<TickTask>();

    public String func_71517_b() {
        return "permadeath";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/permadeath <on|off>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length != 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: " + this.func_71518_a(sender)));
            return;
        }
        if ("on".equalsIgnoreCase(args[0])) {
            if (countdownActive || permadeathEnabled) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "PermaDeath is already active or the countdown is running."));
                return;
            }
            countdownActive = true;
            server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "***** PERMADEATH in 30 seconds *****"));
            PermaDeath.scheduleTask(() -> {
                if (countdownActive) {
                    server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "***** PERMADEATH in 10 seconds *****"));
                }
            }, 400);
            PermaDeath.scheduleTask(() -> {
                if (countdownActive) {
                    server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.RED + "***** PERMADEATH in 3 seconds *****"));
                }
            }, 540);
            PermaDeath.scheduleTask(() -> {
                if (countdownActive) {
                    server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "***** PERMADEATH ACTIVATED *****"));
                    permadeathEnabled = true;
                    server.func_71187_D().func_71556_a((ICommandSender)server, "gamerule keepInventory false");
                    countdownActive = false;
                }
            }, 600);
        } else if ("off".equalsIgnoreCase(args[0])) {
            countdownActive = false;
            permadeathEnabled = false;
            server.func_71187_D().func_71556_a((ICommandSender)server, "gamerule keepInventory true");
            server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "PermaDeath disabled."));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: " + this.func_71518_a(sender)));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return PermaDeath.func_71530_a((String[])args, (String[])new String[]{"on", "off"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        MinecraftServer server;
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (permadeathEnabled && (server = player.func_184102_h()) != null) {
            try {
                server.func_71187_D().func_71556_a((ICommandSender)server, "removeOrigin " + player.func_70005_c_());
            }
            catch (Exception e) {
                System.err.println("Error executing /removeOrigin: " + e.getMessage());
                e.printStackTrace();
            }
            PermaDeath.scheduleTask(() -> {
                try {
                    server.func_71187_D().func_71556_a((ICommandSender)server, "resetSimulations " + player.func_70005_c_());
                }
                catch (Exception e) {
                    System.err.println("Error executing /resetSimulations: " + e.getMessage());
                    e.printStackTrace();
                }
            }, 9);
            PermaDeath.scheduleTask(() -> {
                long banDurationMs = 5000L;
                Date now = new Date();
                Date expireDate = new Date(now.getTime() + banDurationMs);
                UserListBansEntry banEntry = new UserListBansEntry(player.func_146103_bH(), now, "PermaDeath", expireDate, "Temporary ban due to permadeath reset");
                server.func_184103_al().func_152608_h().func_152687_a((UserListEntry)banEntry);
                player.field_71135_a.func_194028_b((ITextComponent)new TextComponentString(TextFormatting.RED + "PermaDeath: You are temporarily banned for 5 seconds. Please rejoin later."));
                this.wipePlayerDataAndAdvancements(server, player.func_70005_c_());
            }, 10);
            PermaDeath.scheduleTask(() -> server.func_184103_al().func_152608_h().func_152684_c((Object)player.func_146103_bH()), 110);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            List<TickTask> list = tickTasks;
            synchronized (list) {
                Iterator<TickTask> iter = tickTasks.iterator();
                while (iter.hasNext()) {
                    TickTask task = iter.next();
                    --task.ticksRemaining;
                    if (task.ticksRemaining > 0) continue;
                    try {
                        task.task.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    iter.remove();
                }
            }
        }
    }

    private void wipePlayerDataAndAdvancements(MinecraftServer server, String playerName) {
        File worldDir = server.func_71218_a(0).func_72860_G().func_75765_b();
        File playerDataDir = new File(worldDir, "playerdata");
        GameProfile profile = server.func_152358_ax().func_152655_a(playerName);
        if (profile != null) {
            File advancementsDir;
            File advancementFile;
            File playerFile = new File(playerDataDir, profile.getId().toString() + ".dat");
            if (playerFile.exists() && playerFile.delete()) {
                System.out.println("Deleted player data file: " + playerFile.getAbsolutePath());
            }
            if ((advancementFile = new File(advancementsDir = new File(worldDir, "advancements"), profile.getId().toString() + ".json")).exists() && advancementFile.delete()) {
                System.out.println("Deleted advancement file: " + advancementFile.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleTask(Runnable task, int delayTicks) {
        List<TickTask> list = tickTasks;
        synchronized (list) {
            tickTasks.add(new TickTask(task, delayTicks));
        }
    }

    private static class TickTask {
        Runnable task;
        int ticksRemaining;

        TickTask(Runnable task, int ticksRemaining) {
            this.task = task;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

