/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tyler.narutoorigin.coremod.PlayerData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.server.MinecraftServer;

public class PlayerDataManager {
    private final String filePath;
    private Map<String, PlayerData> playerDataMap;
    private BlockingQueue<PlayerData> currentQueue;
    private BlockingQueue<PlayerData> nextQueue;
    private final Thread saveThread;
    private volatile boolean isQueueLocked;

    public PlayerDataManager(MinecraftServer server) {
        File worldDirectory = server.func_71218_a(0).func_72860_G().func_75765_b();
        File narutoOriginsDir = new File(worldDirectory, "NarutoOrigins");
        if (!narutoOriginsDir.exists()) {
            narutoOriginsDir.mkdirs();
        }
        this.filePath = Paths.get(narutoOriginsDir.getPath(), "playerDataNarutoOrigins.json").toString();
        this.playerDataMap = new HashMap<String, PlayerData>();
        this.currentQueue = new LinkedBlockingQueue<PlayerData>();
        this.nextQueue = new LinkedBlockingQueue<PlayerData>();
        this.loadPlayerData();
        this.saveThread = new Thread(() -> {
            try {
                while (true) {
                    PlayerData data;
                    this.lockQueue();
                    while ((data = (PlayerData)this.currentQueue.poll()) != null) {
                        this.savePlayerDataToFile();
                    }
                    Thread.sleep(2000L);
                    this.swapQueues();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.saveThread.start();
    }

    public PlayerData getPlayerData(String playerName, String worldName) {
        return this.playerDataMap.computeIfAbsent(playerName + ":" + worldName, k -> new PlayerData(playerName, worldName));
    }

    public void savePlayerData(PlayerData playerData) {
        this.playerDataMap.put(playerData.getName() + ":" + playerData.getWorldName(), playerData);
        if (this.isQueueLocked) {
            this.nextQueue.offer(playerData);
        } else {
            this.currentQueue.offer(playerData);
        }
    }

    public Map<String, PlayerData> getPlayerDataMap() {
        return this.playerDataMap;
    }

    public void savePlayerDataToFile() {
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(this.filePath);){
            gson.toJson(this.playerDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPlayerData() {
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(this.filePath);){
            Type type = new TypeToken<Map<String, PlayerData>>(){}.getType();
            this.playerDataMap = (Map)gson.fromJson((Reader)reader, type);
            if (this.playerDataMap == null) {
                this.playerDataMap = new HashMap<String, PlayerData>();
            }
        }
        catch (FileNotFoundException e) {
            this.playerDataMap = new HashMap<String, PlayerData>();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void lockQueue() {
        this.isQueueLocked = true;
    }

    private void swapQueues() {
        this.isQueueLocked = false;
        BlockingQueue<PlayerData> processedQueue = this.currentQueue;
        this.currentQueue = this.nextQueue;
        this.nextQueue = new LinkedBlockingQueue<PlayerData>();
        processedQueue.clear();
    }

    public void stop() {
        this.saveThread.interrupt();
    }
}

