/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class TailedBeastManager {
    private final String filePath;
    private List<String> tailedBeasts;

    public TailedBeastManager(MinecraftServer server) {
        File worldDirectory = server.func_130014_f_().func_72860_G().func_75765_b();
        File narutoOriginsDir = new File(worldDirectory, "NarutoOrigins");
        if (!narutoOriginsDir.exists()) {
            narutoOriginsDir.mkdirs();
        }
        this.filePath = Paths.get(narutoOriginsDir.getPath(), "TailedBeastAvailable.json").toString();
        this.createTailedBeastFile();
        this.loadTailedBeasts();
    }

    private void createTailedBeastFile() {
        File file = new File(this.filePath);
        if (!file.exists()) {
            this.tailedBeasts = new ArrayList<String>(Arrays.asList("Shukaku", "Matatabi", "Isobu", "Son Goku", "Kokuo", "Saiken", "Chomei", "Gyuki", "Kurama"));
            this.saveTailedBeasts();
        }
    }

    private void loadTailedBeasts() {
        try (FileReader reader = new FileReader(this.filePath);){
            Gson gson = new Gson();
            Type listType = new TypeToken<List<String>>(){}.getType();
            this.tailedBeasts = (List)gson.fromJson((Reader)reader, listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveTailedBeasts() {
        try (FileWriter writer = new FileWriter(this.filePath);){
            Gson gson = new Gson();
            gson.toJson(this.tailedBeasts, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean claimTailedBeast(String tailedBeast) {
        if (this.tailedBeasts.contains(tailedBeast)) {
            this.tailedBeasts.remove(tailedBeast);
            this.saveTailedBeasts();
            return true;
        }
        return false;
    }

    public List<String> getAvailableTailedBeasts() {
        return new ArrayList<String>(this.tailedBeasts);
    }

    public static void initialize(MinecraftServer server) {
        new TailedBeastManager(server);
    }
}

