/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.ranks;

import com.tyler.narutoorigin.ranks.PlayerRankData;
import com.tyler.narutoorigin.ranks.RankManager;
import com.tyler.narutoorigin.ranks.RankRatja;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandAssignRank
extends CommandBase {
    public String func_71517_b() {
        return "assignRank";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/assignRank <player> <rank>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /assignRank <player> <rank>"));
            return;
        }
        String playerName = args[0];
        String rankName = args[1];
        if (!RankManager.ranks.containsKey(rankName)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Rank doesn't exist."));
            return;
        }
        RankRatja rankDef = RankManager.ranks.get(rankName);
        PlayerRankData data = RankManager.playerRanks.get(playerName);
        if (data == null) {
            data = new PlayerRankData();
        }
        if (rankDef.getPosition().equalsIgnoreCase("prefix")) {
            data.setPrefix(rankName);
        } else {
            data.setSuffix(rankName);
        }
        RankManager.playerRanks.put(playerName, data);
        RankManager.saveRanks();
        sender.func_145747_a((ITextComponent)new TextComponentString(playerName + " got the rank " + rankName + "."));
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player != null) {
            CommandAssignRank.updateScoreboardTeam(player, data);
        }
    }

    public static void updateScoreboardTeam(EntityPlayerMP player, PlayerRankData data) {
        String teamName;
        Scoreboard scoreboard = player.func_96123_co();
        ScorePlayerTeam team = scoreboard.func_96508_e(teamName = "r_" + Integer.toHexString(player.func_70005_c_().hashCode()));
        if (team == null) {
            team = scoreboard.func_96527_f(teamName);
        }
        String prefixText = "";
        String suffixText = "";
        TextFormatting dominantColor = TextFormatting.WHITE;
        if (data.getPrefix() != null && RankManager.ranks.containsKey(data.getPrefix())) {
            RankRatja prefixDef = RankManager.ranks.get(data.getPrefix());
            dominantColor = TextFormatting.func_96300_b((String)prefixDef.getColor().toUpperCase());
            if (dominantColor == null) {
                dominantColor = TextFormatting.WHITE;
            }
            prefixText = dominantColor + prefixDef.getName() + " " + dominantColor;
            if (data.getSuffix() != null && RankManager.ranks.containsKey(data.getSuffix())) {
                suffixText = " " + dominantColor + RankManager.ranks.get(data.getSuffix()).getName();
            }
        } else if (data.getSuffix() != null && RankManager.ranks.containsKey(data.getSuffix())) {
            RankRatja suffixDef = RankManager.ranks.get(data.getSuffix());
            dominantColor = TextFormatting.func_96300_b((String)suffixDef.getColor().toUpperCase());
            if (dominantColor == null) {
                dominantColor = TextFormatting.WHITE;
            }
            prefixText = dominantColor.toString();
            suffixText = " " + dominantColor + suffixDef.getName();
        } else {
            prefixText = "";
            suffixText = "";
            dominantColor = TextFormatting.WHITE;
        }
        team.func_96666_b(prefixText);
        team.func_96662_c(suffixText);
        scoreboard.func_151392_a(player.func_70005_c_(), team.func_96661_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandAssignRank.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandAssignRank.func_175762_a((String[])args, RankManager.ranks.keySet());
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

