/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.ranks;

import com.tyler.narutoorigin.ranks.RankManager;
import com.tyler.narutoorigin.ranks.RankRatja;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandCreateRank
extends CommandBase {
    private static final List<String> COLORS = Arrays.asList("BLACK", "DARK_BLUE", "DARK_GREEN", "DARK_AQUA", "DARK_RED", "DARK_PURPLE", "GOLD", "GRAY", "DARK_GRAY", "BLUE", "GREEN", "AQUA", "RED", "LIGHT_PURPLE", "YELLOW", "WHITE");

    public String func_71517_b() {
        return "createRank";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/createRank <name> <color> <prefix|suffix>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length != 3) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /createRank <name> <color> <prefix|suffix>"));
            return;
        }
        String rankName = args[0];
        String color = args[1].toUpperCase();
        String position = args[2].toLowerCase();
        if (!position.equals("prefix") && !position.equals("suffix")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Position must be either 'prefix' or 'suffix'."));
            return;
        }
        if (!COLORS.contains(color)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("This color does not exist!"));
            return;
        }
        RankRatja rank = new RankRatja(rankName, color, position);
        RankManager.ranks.put(rankName, rank);
        RankManager.saveRanks();
        sender.func_145747_a((ITextComponent)new TextComponentString("Rank " + rankName + " created successfully."));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            return CommandCreateRank.func_175762_a((String[])args, COLORS);
        }
        if (args.length == 3) {
            return CommandCreateRank.func_175762_a((String[])args, Arrays.asList("prefix", "suffix"));
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

