/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.ranks;

import com.tyler.narutoorigin.ranks.CommandAssignRank;
import com.tyler.narutoorigin.ranks.PlayerRankData;
import com.tyler.narutoorigin.ranks.RankManager;
import java.util.HashSet;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandRemoveRank
extends CommandBase {
    public String func_71517_b() {
        return "removeRank";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/removeRank <player> <rank>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: " + this.func_71518_a(sender)));
            return;
        }
        String playerName = args[0];
        String rankName = args[1];
        if (!RankManager.playerRanks.containsKey(playerName)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Player " + playerName + " has no rank assigned."));
            return;
        }
        PlayerRankData data = RankManager.playerRanks.get(playerName);
        boolean removed = false;
        if (data.getPrefix() != null && data.getPrefix().equalsIgnoreCase(rankName)) {
            data.setPrefix(null);
            removed = true;
        }
        if (data.getSuffix() != null && data.getSuffix().equalsIgnoreCase(rankName)) {
            data.setSuffix(null);
            removed = true;
        }
        if (!removed) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Player " + playerName + " does not have rank " + rankName + "."));
            return;
        }
        if (data.getPrefix() == null && data.getSuffix() == null) {
            RankManager.playerRanks.remove(playerName);
        } else {
            RankManager.playerRanks.put(playerName, data);
        }
        RankManager.saveRanks();
        sender.func_145747_a((ITextComponent)new TextComponentString("Removed rank " + rankName + " from player " + playerName + "."));
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player != null) {
            Scoreboard scoreboard = player.func_96123_co();
            for (ScorePlayerTeam team : scoreboard.func_96525_g()) {
                if (!team.func_96661_b().startsWith("r_")) continue;
                scoreboard.func_96512_b(playerName, team);
            }
            PlayerRankData newData = RankManager.playerRanks.get(playerName);
            if (newData != null && (newData.getPrefix() != null || newData.getSuffix() != null)) {
                CommandAssignRank.updateScoreboardTeam(player, newData);
            } else {
                player.refreshDisplayName();
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        String playerName;
        if (args.length == 1) {
            return CommandRemoveRank.func_175762_a((String[])args, RankManager.playerRanks.keySet());
        }
        if (args.length == 2 && RankManager.playerRanks.containsKey(playerName = args[0])) {
            PlayerRankData data = RankManager.playerRanks.get(playerName);
            HashSet<String> suggestions = new HashSet<String>();
            if (data.getPrefix() != null) {
                suggestions.add(data.getPrefix());
            }
            if (data.getSuffix() != null) {
                suggestions.add(data.getSuffix());
            }
            return CommandRemoveRank.func_175762_a((String[])args, suggestions);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

