/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.ranks;

import com.tyler.narutoorigin.ranks.PlayerRankData;
import com.tyler.narutoorigin.ranks.RankManager;
import com.tyler.narutoorigin.ranks.RankRatja;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RankChatEventRatja {
    private static final HashMap<String, TextFormatting> colorMap = new HashMap();

    @SubscribeEvent
    public void onChat(ServerChatEvent event) {
        EntityPlayerMP player = event.getPlayer();
        PlayerRankData data = RankManager.playerRanks.get(player.func_70005_c_());
        if (data != null) {
            String prefixStr = "";
            String suffixStr = "";
            TextFormatting dominantColor = TextFormatting.WHITE;
            if (data.getPrefix() != null && RankManager.ranks.containsKey(data.getPrefix())) {
                RankRatja prefixRank = RankManager.ranks.get(data.getPrefix());
                dominantColor = TextFormatting.func_96300_b((String)prefixRank.getColor().toUpperCase());
                if (dominantColor == null) {
                    dominantColor = TextFormatting.WHITE;
                }
                prefixStr = dominantColor + prefixRank.getName();
            }
            if (data.getSuffix() != null && RankManager.ranks.containsKey(data.getSuffix())) {
                RankRatja suffixRank = RankManager.ranks.get(data.getSuffix());
                if (prefixStr.isEmpty() && (dominantColor = TextFormatting.func_96300_b((String)suffixRank.getColor().toUpperCase())) == null) {
                    dominantColor = TextFormatting.WHITE;
                }
                suffixStr = dominantColor + suffixRank.getName();
            }
            String coloredPlayerName = dominantColor + player.func_70005_c_();
            String formattedMessage = !prefixStr.isEmpty() && !suffixStr.isEmpty() ? prefixStr + " " + coloredPlayerName + " " + suffixStr + TextFormatting.WHITE + ": " + event.getMessage() : (!prefixStr.isEmpty() ? prefixStr + " " + coloredPlayerName + TextFormatting.WHITE + ": " + event.getMessage() : (!suffixStr.isEmpty() ? coloredPlayerName + " " + suffixStr + TextFormatting.WHITE + ": " + event.getMessage() : coloredPlayerName + TextFormatting.WHITE + ": " + event.getMessage()));
            event.setComponent((ITextComponent)new TextComponentString(formattedMessage));
        }
    }

    @SubscribeEvent
    public void onNameFormat(PlayerEvent.NameFormat event) {
        EntityPlayer player = event.getEntityPlayer();
        PlayerRankData data = RankManager.playerRanks.get(player.func_70005_c_());
        if (data != null) {
            String prefixStr = "";
            String suffixStr = "";
            TextFormatting dominantColor = TextFormatting.WHITE;
            if (data.getPrefix() != null && RankManager.ranks.containsKey(data.getPrefix())) {
                RankRatja prefixRank = RankManager.ranks.get(data.getPrefix());
                dominantColor = TextFormatting.func_96300_b((String)prefixRank.getColor().toUpperCase());
                if (dominantColor == null) {
                    dominantColor = TextFormatting.WHITE;
                }
                prefixStr = dominantColor + prefixRank.getName();
            }
            if (data.getSuffix() != null && RankManager.ranks.containsKey(data.getSuffix())) {
                RankRatja suffixRank = RankManager.ranks.get(data.getSuffix());
                if (prefixStr.isEmpty() && (dominantColor = TextFormatting.func_96300_b((String)suffixRank.getColor().toUpperCase())) == null) {
                    dominantColor = TextFormatting.WHITE;
                }
                suffixStr = dominantColor + suffixRank.getName();
            }
            String coloredPlayerName = dominantColor + player.func_70005_c_();
            String displayName = !prefixStr.isEmpty() && !suffixStr.isEmpty() ? prefixStr + " " + coloredPlayerName + " " + suffixStr : (!prefixStr.isEmpty() ? prefixStr + " " + coloredPlayerName : (!suffixStr.isEmpty() ? coloredPlayerName + " " + suffixStr : player.func_70005_c_()));
            event.setDisplayname(displayName);
        } else {
            event.setDisplayname(player.func_70005_c_());
        }
    }

    static {
        colorMap.put("BLACK", TextFormatting.BLACK);
        colorMap.put("DARK_BLUE", TextFormatting.DARK_BLUE);
        colorMap.put("DARK_GREEN", TextFormatting.DARK_GREEN);
        colorMap.put("DARK_AQUA", TextFormatting.DARK_AQUA);
        colorMap.put("DARK_RED", TextFormatting.DARK_RED);
        colorMap.put("DARK_PURPLE", TextFormatting.DARK_PURPLE);
        colorMap.put("GOLD", TextFormatting.GOLD);
        colorMap.put("GRAY", TextFormatting.GRAY);
        colorMap.put("DARK_GRAY", TextFormatting.DARK_GRAY);
        colorMap.put("BLUE", TextFormatting.BLUE);
        colorMap.put("GREEN", TextFormatting.GREEN);
        colorMap.put("AQUA", TextFormatting.AQUA);
        colorMap.put("RED", TextFormatting.RED);
        colorMap.put("LIGHT_PURPLE", TextFormatting.LIGHT_PURPLE);
        colorMap.put("YELLOW", TextFormatting.YELLOW);
        colorMap.put("WHITE", TextFormatting.WHITE);
    }
}

