/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.ranks;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tyler.narutoorigin.ranks.PlayerRankData;
import com.tyler.narutoorigin.ranks.RankRatja;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class RankManager {
    private static final Gson gson = new Gson();
    private static final File dir = new File("OriginsRanks");
    private static final File ranksFile = new File(dir, "ranks.json");
    private static final File playerRanksFile = new File(dir, "playerRanks.json");
    public static HashMap<String, RankRatja> ranks = new HashMap();
    public static HashMap<String, PlayerRankData> playerRanks = new HashMap();

    public static void loadRanks() {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!ranksFile.exists()) {
                ranksFile.createNewFile();
            }
            if (!playerRanksFile.exists()) {
                playerRanksFile.createNewFile();
            }
            FileReader rankReader = new FileReader(ranksFile);
            FileReader playerRankReader = new FileReader(playerRanksFile);
            ranks = (HashMap)gson.fromJson((Reader)rankReader, new TypeToken<HashMap<String, RankRatja>>(){}.getType());
            playerRanks = (HashMap)gson.fromJson((Reader)playerRankReader, new TypeToken<HashMap<String, PlayerRankData>>(){}.getType());
            if (ranks == null) {
                ranks = new HashMap();
            }
            if (playerRanks == null) {
                playerRanks = new HashMap();
            }
            rankReader.close();
            playerRankReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveRanks() {
        try {
            FileWriter rankWriter = new FileWriter(ranksFile);
            FileWriter playerRankWriter = new FileWriter(playerRanksFile);
            gson.toJson(ranks, (Appendable)rankWriter);
            gson.toJson(playerRanks, (Appendable)playerRankWriter);
            rankWriter.close();
            playerRankWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static RankRatja getEffectiveRank(EntityPlayer player) {
        PlayerRankData data = playerRanks.get(player.func_70005_c_());
        if (data != null) {
            if (data.getPrefix() != null && ranks.containsKey(data.getPrefix())) {
                return ranks.get(data.getPrefix());
            }
            if (data.getSuffix() != null && ranks.containsKey(data.getSuffix())) {
                return ranks.get(data.getSuffix());
            }
        }
        return null;
    }
}

