/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/

		const float torchlightBrightness = TORCHLIGHT_BRIGHTNESS;
		float lightSourceMask = 1.0;

		if (materialMaskSoild.glowstone
			+ materialMaskSoild.torch
			+ materialMaskSoild.entitysLitHigh
			+ materialMaskSoild.entitysLitMedium
			+ materialMaskSoild.entitysLitLow
			+ materialMaskSoild.particlelit
			+ materialMaskSoild.soulFire
			+ materialMaskSoild.amethyst > 0.5)
		lightSourceMask = 0.0;

		vec3 blockLighting = gbuffer.lightmapL.r * colorTorchlight * lightSourceMask * gbuffer.albedo * ao;

		float albedoLuminance = length(gbuffer.albedo.rgb);
		vec3 albedo2 = gbuffer.albedo * albedoLuminance;

		float blockLightingMask = materialMaskSoild.glowstone * 5.0;
		blockLightingMask += materialMaskSoild.torch * 5.0;
		blockLightingMask += materialMaskSoild.fire * 3.0;
		blockLightingMask += materialMaskSoild.lava * 3.0;
		blockLightingMask += materialMaskSoild.redstoneTorch * 0.5;

		blockLightingMask += materialMaskSoild.lapisBlock * GLOWING_LAPIS_BLOCK_STRENGTH;
		blockLightingMask += materialMaskSoild.emeraldBlock * GLOWING_EMERALD_BLOCK_STRENGTH;
		blockLightingMask += materialMaskSoild.diamondBlock * GLOWING_DIAMOND_BLOCK_STRENGTH;

        blockLightingMask += materialMaskSoild.beacon * 5.0;


		blockLighting += blockLightingMask * colorTorchlight * albedo2;

		blockLightingMask = materialMaskSoild.soulFire * 0.2;
		blockLightingMask += materialMaskSoild.amethyst * 0.03;
		blockLightingMask += materialMaskSoild.entitysLitHigh * 2.0;
		blockLightingMask += materialMaskSoild.entitysLitMedium * 1.0;
		blockLightingMask += materialMaskSoild.entitysLitLow * 0.5;
		blockLightingMask += materialMaskSoild.particlelit * 1.0;
		blockLightingMask += materialMaskSoild.eyes * 3.0;

		blockLighting += blockLightingMask * albedo2;

		finalComposite += blockLighting * torchlightBrightness;