/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


#include "/Include/Settings.glsl"
#include "/Include/Core/Core.glsl"

uniform int renderStage;

uniform sampler2D texture;


in vec4 color;
in vec2 texcoord;
in vec3 normal;
in vec2 blockLight;

#include "/Include/LightJitter.glsl"

void main(){
    vec4 albedo = color;

	vec2 mcLightmap = blockLight;

	float materialIDs = 1.0;
    if (renderStage == MC_RENDER_STAGE_OUTLINE || renderStage == MC_RENDER_STAGE_DEBUG)
    {
        if (renderStage == MC_RENDER_STAGE_OUTLINE) albedo.rgb = vec3(SELECTION_BOX_COLOR);
        materialIDs = 200.0;
		mcLightmap = vec2(0.0);
    }

	if(albedo.a < 0.1) discard;

	gl_FragData[0] = vec4(albedo.rgb, 1.0);
	gl_FragData[1] = vec4(EncodeNormal(normal), mcLightmap);
	gl_FragData[2] = vec4(0.0, 0.0, (materialIDs + 0.1) / 255.0, 1.0);
}

/* DRAWBUFFERS:036 */
