
/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/

#include "/Include/Settings.glsl"

uniform sampler2D texture;
#ifndef COMPATIBLE_MODE
	uniform int renderStage;
#endif
in vec4 color;
in vec4 texcoord;
in vec3 normal;
in vec2 blockLight;

#include "/Include/Core/Core.glsl"

#include "/Include/LightJitter.glsl"

void main(){
    vec4 albedo = color;

    #include "/Include/Debug/WhiteWorld.glsl"


#ifdef COMPATIBLE_MODE
	float materialIDs = 200.0;
	gl_FragData[0] = vec4(albedo);
	gl_FragData[2] = vec4(0.0, 0.0, (materialIDs + 0.1) / 255.0, 1.0);
#else
	float materialIDs = 1.0;
    if (renderStage == MC_RENDER_STAGE_OUTLINE)
    {
        albedo.rgb = vec3(1.0);
        materialIDs = 200.0;
    }

    if (renderStage == MC_RENDER_STAGE_DEBUG)
    {
        materialIDs = 200.0;
    }

	vec2 mcLightmap = blockLight.xy;
	mcLightmap.x = CurveBlockLightTorch(mcLightmap.x);
	mcLightmap.x = pow(mcLightmap.x, 0.25);

	gl_FragData[0] = vec4(albedo);
	gl_FragData[1] = vec4(EncodeNormal(normal), mcLightmap);
	gl_FragData[2] = vec4(0.0, 0.0, (materialIDs + 0.1) / 255.0, 1.0);
#endif
}

/* DRAWBUFFERS:036 */
