
/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


#include "/Include/Settings.glsl"

uniform vec2 taaJitter;

out vec4 color;
out vec4 texcoord;
out vec3 worldNormal;
out vec4 viewPos;
out vec2 blockLight;
out float materialIDs;

void main(){
    viewPos = gl_ModelViewMatrix * gl_Vertex;
	gl_Position = gl_ProjectionMatrix * viewPos;
	
    #ifdef TAA
    #include "/Include/AntiAliasing/TAA.glsl"
    #endif


	color = gl_Color;
    texcoord = gl_MultiTexCoord0;
    worldNormal = gl_Normal;

    vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
    blockLight.x = clamp((lmcoord.x * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
    blockLight.y = clamp((lmcoord.y * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);

    materialIDs = 7.0;
}
