/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


#include "/Include/Settings.glsl"
#include "/Include/Uniforms.glsl"

out vec4 color;
out vec4 texcoord;
out vec2 blockLight;
out float materialIDs;

void main(){
    gl_Position = ftransform();
 
   #include "/Include/SphericalWorld.glsl"
 
    #ifdef TAA
    #include "/Include/AntiAliasing/TAA.glsl"
    #endif

    color = gl_Color;
    texcoord = gl_MultiTexCoord0;

    vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
    blockLight.x = clamp((lmcoord.x * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
    blockLight.y = clamp((lmcoord.y * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);

    materialIDs = 39;
    if(lmcoord.x > 0.965) materialIDs = 40;
}
