/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvtron

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/

vec4 netherFogColor = vec4(0.0);

void calculateNetherFogColor() {
    netherFogColor = vec4(0.99, 0.17, 0.005, 0.007) * BiomeNetherWastesSmooth +
                     vec4(0.01, 0.035, 0.06, 0.005) * BiomeSoulSandValleySmooth +
                     vec4(0.2, 0.02, 0.0, 0.007) * BiomeCrimsonForestSmooth +
                     vec4(0.03, 0.1, 0.13, 0.005) * BiomeWarpedForestSmooth +
                     vec4(0.4, 0.4, 0.4, 0.01) * BiomeBasaltDeltasSmooth;
}

vec3 NetherFog(float dist) {
    dist = min(dist, far * 1.2);
    
    float fogDensity = netherFogColor.w;
    float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);
    
    return fogFactor * netherFogColor.xyz * 0.5;
}

vec4 NetherFogColor() {
    return vec4(0.99, 0.17, 0.005, 0.007) * BiomeNetherWastesSmooth +
           vec4(0.01, 0.035, 0.06, 0.005) * BiomeSoulSandValleySmooth +
           vec4(0.2, 0.02, 0.0, 0.007) * BiomeCrimsonForestSmooth +
           vec4(0.03, 0.1, 0.13, 0.005) * BiomeWarpedForestSmooth +
           vec4(0.4, 0.4, 0.4, 0.01) * BiomeBasaltDeltasSmooth;
}

vec3 NetherFog(float dist) {
    dist = min(dist, far * 1.2);
    
    vec4 fogData = NetherFogColor();
    float fogFactor = pow(1.0 - exp(-dist * fogData.w), 2.0);
    
    return fogFactor * fogData.xyz * 0.5;
}