/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvtron

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


#define CLOUD_SHADOWTEX_SIZE 256.0 // [128.0 192.0 256.0 384.0 512.0 768.0 1024.0]
#define DIMENSION_MAIN
#define COLORTEX_CLOUDNOISE


#include "/Include/Uniforms.glsl"

#include "/Include/Core/Core.glsl"

layout(location = 0) out vec4 compositeOutput2;


ivec2 texelCoord = ivec2(gl_FragCoord.xy);

vec4 AxialGaussianBlur(){
	ivec4 shadowTexBorder = ivec4(screenSize - floor(min(screenSize.y * 0.45, CLOUD_SHADOWTEX_SIZE)), screenSize - 1.0);

	vec4 blur = vec4(0.0);

	ivec2 sampleCoord = clamp(ivec2(texelCoord.x - 3, texelCoord.y), shadowTexBorder.xy, shadowTexBorder.zw);
	blur.r += texelFetch(colortex2, sampleCoord, 0).r * 0.054543;

	sampleCoord = clamp(ivec2(texelCoord.x - 2, texelCoord.y), shadowTexBorder.xy, shadowTexBorder.zw);
	blur.r += texelFetch(colortex2, sampleCoord, 0).r * 0.099384;

	sampleCoord = clamp(ivec2(texelCoord.x - 1, texelCoord.y), shadowTexBorder.xy, shadowTexBorder.zw);
	blur.r += texelFetch(colortex2, sampleCoord, 0).r * 0.181090;

	vec4 data2 = texelFetch(colortex2, texelCoord, 0);
	blur.r += data2.r * 0.329966;
	blur.gba += data2.gba;

	sampleCoord = clamp(ivec2(texelCoord.x + 1, texelCoord.y), shadowTexBorder.xy, shadowTexBorder.zw);
	blur.r += texelFetch(colortex2, sampleCoord, 0).r * 0.181090;

	sampleCoord = clamp(ivec2(texelCoord.x + 2, texelCoord.y), shadowTexBorder.xy, shadowTexBorder.zw);
	blur.r += texelFetch(colortex2, sampleCoord, 0).r * 0.099384;

	sampleCoord = clamp(ivec2(texelCoord.x + 3, texelCoord.y), shadowTexBorder.xy, shadowTexBorder.zw);
	blur.r += texelFetch(colortex2, sampleCoord, 0).r * 0.054543;

	return blur;
}

void main(){
	compositeOutput2 = AxialGaussianBlur();
}

/* DRAWBUFFERS:2 */
