#====================================================================================================#
#                                                                                                    #
#   Copyright (C) 2025 Pyvtron VX Shaders - Pyvtron                                                  #
#                                                                                                    #
#    All Rights Reserved unless otherwise explicitly stated.                                         #
#                                                                                                    #
#    Before You Do Something With Pyvtron VX Shaders, You MUST Read The License                      #
#                                                                                                    #
#    License Here: https://pyvtron.gitlab.io/licenses/pcll                                           #
#                                                                                                    #
#====================================================================================================#

#include "/Include/GI.glsl"

float CalculateDitherPattern1() {
	const int[16] ditherPattern = int[16] (0, 8, 2, 10,
									 	   12, 4, 14, 6,
									 	   3, 11, 1, 9,
									 	   15, 7, 13, 5);

	vec2 count = vec2(0.0);
	     count.x = floor(mod(texcoord.s * viewWidth, 4.0));
		 count.y = floor(mod(texcoord.t * viewHeight, 4.0));

	int dither = ditherPattern[int(fma(int(count.y), 4, int(count.x)))];

	return float(dither) / 16.0;
}

vec4 textureSmooth(in sampler2D h, in vec2 j)
{
    vec2 texSize = vec2(64.0, 64.0);

    vec2 coordTex = ((j * texSize) + vec2(-0.5, -0.5));
    
    vec2 iCoord = floor(coordTex);
    vec2 fCoord = fract(coordTex);

    vec4 tex00 = texture2D(h, ((iCoord + vec2(0.0, 0.0)) + vec2(0.5, 0.5)) / texSize);
    vec4 tex10 = texture2D(h, ((iCoord + vec2(1.0, 0.0)) + vec2(0.5, 0.5)) / texSize);
    vec4 tex01 = texture2D(h, ((iCoord + vec2(0.0, 1.0)) + vec2(0.5, 0.5)) / texSize);
    vec4 tex11 = texture2D(h, ((iCoord + vec2(1.0, 1.0)) + vec2(0.5, 0.5)) / texSize);

    vec4 tex0 = mix(tex00, tex10, (fCoord.x * 1.0));
    vec4 tex1 = mix(tex01, tex11, (fCoord.x * 1.0));
    vec4 texFinal = mix(tex0, tex1, (fCoord.y * 1.0));

    return (texFinal);
}

float AlmostIdentity(in float x, in float m, in float n)
{
    if (x > m)
        return x;

    float a = (2.0 * n) - m;
    float b = (2.0 * m) - (3.0 * n);
    float t = x / m;

    return ((a * t) + b) * t * t + n;
}