/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvtron

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


vec3 RGBcircling(float time, float phaseDiff, float rndfactor, float speed)
{
	time *= speed;
	time += phaseDiff * 3.0f * rndfactor;

	float timeR = clamp(abs(mod(time, 						phaseDiff * 3.0f) - phaseDiff * 1.5f) ,0.0f, 180.0f);
	float timeG = clamp(abs(mod(time + phaseDiff, 			phaseDiff * 3.0f) - phaseDiff * 1.5f) ,0.0f, 180.0f);
	float timeB = clamp(abs(mod(time + phaseDiff * 2.0f, 	phaseDiff * 3.0f) - phaseDiff * 1.5f) ,0.0f, 180.0f);

	vec3 RGB = vec3(cos(radians(timeR)), cos(radians(timeG)), cos(radians(timeB)));

	return RGB * 0.5 + 0.5;
}
