
/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvtron

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


float GetWaves(vec3 position) {
    float wavesTime = frameTimeCounter * WATER_CAUSTICS_SPEED;

    vec2 baseP = position.xz / 20.0 - position.y / 15.0;

    float rotAngle1 = wavesTime * 0.4 + 0.3 * sin(wavesTime * 0.7 + 1.0);
    float rotAngle2 = wavesTime * 0.7 + 0.4 * cos(wavesTime * 0.5 + 2.0);
    float rotAngle3 = wavesTime * 1.2 + 0.25 * sin(wavesTime * 0.9 + 3.0);
    float rotAngle4 = wavesTime * 0.9 + 0.2 * cos(wavesTime * 0.8 + 4.0);

    mat2 rot1 = mat2(cos(rotAngle1), sin(rotAngle1), -sin(rotAngle1), cos(rotAngle1));
    mat2 rot2 = mat2(cos(rotAngle2), sin(rotAngle2), -sin(rotAngle2), cos(rotAngle2));
    mat2 rot3 = mat2(cos(rotAngle3), sin(rotAngle3), -sin(rotAngle3), cos(rotAngle3));
    mat2 rot4 = mat2(cos(rotAngle4), sin(rotAngle4), -sin(rotAngle4), cos(rotAngle4));

    vec2 steer1 = vec2(0.2 * sin(wavesTime * 0.9 + 1.3), 0.15 * cos(wavesTime * 0.7 + 1.8));
    vec2 steer2 = vec2(0.3 * cos(wavesTime * 0.6 + 2.3), 0.1 * sin(wavesTime * 0.5 + 2.9));
    vec2 steer3 = vec2(0.15 * sin(wavesTime * 1.0 + 3.2), 0.25 * cos(wavesTime * 0.8 + 3.7));
    vec2 steer4 = vec2(0.1 * cos(wavesTime * 0.4 + 4.1), 0.1 * sin(wavesTime * 0.3 + 4.5));

    vec2 p1 = rot1 * baseP * 1.0 + steer1;
    vec2 p2 = rot2 * baseP * 1.3 + steer2;
    vec2 p3 = rot3 * baseP * 0.7 + steer3;
    vec2 p4 = rot4 * baseP * 1.5 + steer4;

    float amplitude1 = 0.05 + 0.02 * sin(wavesTime * 0.6);
    float amplitude2 = 0.1 + 0.03 * cos(wavesTime * 0.4);
    float amplitude3 = 0.07 + 0.025 * sin(wavesTime * 0.8);
    float amplitude4 = 0.06 + 0.02 * cos(wavesTime * 0.9);

    float wave1 = textureSmooth(noisetex, p1 * vec2(3.0, 2.0) + vec2(0.0, p1.x * 2.0)).z * amplitude1;
    float wave2 = textureSmooth(noisetex, p2 * vec2(2.0, 1.5) + vec2(0.0, -p2.x * 1.8)).y * amplitude2;
    float wave3 = textureSmooth(noisetex, p3 * vec2(1.2, 1.0) + vec2(0.0, p3.x * 1.2)).x * amplitude3;
    float wave4 = textureSmooth(noisetex, p4 * vec2(1.5, 1.2)).x * amplitude4;

    float combinedWaves = wave1 + wave2 + wave3 + wave4;

    float kaustikIntensity = pow(combinedWaves * 5.0, 2.0);

    kaustikIntensity = clamp(kaustikIntensity, 0.0, 1.0);

    return kaustikIntensity * 0.12;
}
