#version 460 compatibility

/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvtron

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvtron.gitlab.io/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


#include "/Include/Settings.glsl"

uniform vec2 taaJitter;

#ifdef DISTANT_HORIZONS
uniform bool dh_is_lod;
uniform mat4 dh_modelViewMatrix;
uniform mat4 dh_projectionMatrix;
#endif

out vec4 color;
out vec2 texcoord;
out vec3 normal;
out vec2 blockLight;

void main() {
    color = gl_Color;
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    #ifdef DISTANT_HORIZONS
    if (dh_is_lod) {
        blockLight = vec2(0.9);
    } else {
        vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
        blockLight.x = clamp(lmcoord.x * 1.066875 - 0.0334375, 0.0, 1.0);
        blockLight.y = clamp(lmcoord.y * 1.066875 - 0.0334375, 0.0, 1.0);
    }
    #else
    vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
    blockLight.x = clamp(lmcoord.x * 1.066875 - 0.0334375, 0.0, 1.0);
    blockLight.y = clamp(lmcoord.y * 1.066875 - 0.0334375, 0.0, 1.0);
    #endif

    #ifdef DISTANT_HORIZONS
    if (dh_is_lod) {
        gl_Position = dh_projectionMatrix * dh_modelViewMatrix * gl_Vertex;
    } else {
        gl_Position = ftransform();
        #ifdef TAA
        gl_Position.xy += taaJitter * gl_Position.w;
        #endif
    }
    #else
    gl_Position = ftransform();
    #ifdef TAA
    gl_Position.xy += taaJitter * gl_Position.w;
    #endif
    #endif

    #ifdef DISTANT_HORIZONS
    if (dh_is_lod) {
        mat3 normalMatrix = mat3(
            dh_modelViewMatrix[0].xyz,
            dh_modelViewMatrix[1].xyz,
            dh_modelViewMatrix[2].xyz
        );
        vec3 worldNormal = normalMatrix * gl_Normal.xyz;
        normal = length(worldNormal) > 0.1 ? normalize(worldNormal) : vec3(0.0, 1.0, 0.0);
    } else {
        normal = normalize(gl_NormalMatrix * gl_Normal.xyz);
    }
    #else
    normal = normalize(gl_NormalMatrix * gl_Normal.xyz);
    #endif
}