/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


#include "/Include/Settings.glsl"

uniform sampler2D texture;

in vec4 color;
in vec4 texcoord;
in vec2 blockLight;
in float materialIDs;

#include "/Include/Core/Core.glsl"

#include "/Include/LightJitter.glsl"

void main(){
    vec4 albedo = texture2D(texture, texcoord.st);
    albedo *= color;

	#ifdef WHITE_DEBUG_WORLD
        albedo.rgb = vec3(1.0);
    #endif

	vec2 normalEnc = EncodeNormal(vec3(0.0, 0.0, 1.0));

    vec2 mcLightmap = blockLight.xy;
    mcLightmap.x = CurveBlockLightTorch(mcLightmap.x);
    mcLightmap.x = pow(mcLightmap.x, 0.25);

    gl_FragData[0] = albedo;
    gl_FragData[1] = vec4(normalEnc, mcLightmap);
    gl_FragData[2] = vec4(0.0, 0.0, (materialIDs + 0.1) / 255.0, 1.0);
}
/* DRAWBUFFERS:036 */
