
/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/


float GetWaves(vec3 position) {
    float wavesTime = frameTimeCounter * WATER_WAVES_SPEED;

    vec2 baseP = position.xz / 20.0 - position.y / 15.0;

    float rotAngle1 = wavesTime * 0.4 + 0.2 * sin(wavesTime * 0.5 + 1.0);
    float rotAngle2 = wavesTime * 0.7 + 0.3 * cos(wavesTime * 0.3 + 2.0);
    float rotAngle3 = wavesTime * 1.2 + 0.15 * sin(wavesTime * 0.8 + 3.0);
    float rotAngle4 = 0.0;

    mat2 rot1 = mat2(cos(rotAngle1), sin(rotAngle1), -sin(rotAngle1), cos(rotAngle1));
    mat2 rot2 = mat2(cos(rotAngle2), sin(rotAngle2), -sin(rotAngle2), cos(rotAngle2));
    mat2 rot3 = mat2(cos(rotAngle3), sin(rotAngle3), -sin(rotAngle3), cos(rotAngle3));

    vec2 steer1 = vec2(0.2 * sin(wavesTime * 0.7 + 1.1), 0.1 * cos(wavesTime * 0.9 + 1.5));
    vec2 steer2 = vec2(0.3 * cos(wavesTime * 0.5 + 2.1), 0.15 * sin(wavesTime * 0.4 + 2.7));
    vec2 steer3 = vec2(0.1 * sin(wavesTime * 0.8 + 3.1), 0.2 * cos(wavesTime * 0.6 + 3.6));

    vec2 p1 = rot1 * baseP * 1.0 + steer1;
    vec2 p2 = rot2 * baseP * 1.3 + steer2;
    vec2 p3 = rot3 * baseP * 0.7 + steer3;

    vec2 dir4 = normalize(vec2(1.0, 0.6));
    vec2 steer4 = vec2(0.1 * sin(wavesTime * 0.3), 0.1 * cos(wavesTime * 0.2));
    vec2 p4 = baseP * 1.5 + dir4 * (wavesTime * 0.5) + steer4;

    float wavesSum = 0.0;
    float weightSum = 0.0;

    float amplitude = 0.08;

    {
        float weight = 1.0;
        weightSum += weight;
        vec2 uv = p1 * vec2(2.5, 1.8) + vec2(0.0, p1.x * 2.2);
        uv.x -= wavesTime * 0.15;
        uv.y -= wavesTime * 0.1;
        float wave = textureSmooth(noisetex, uv).z;
        wavesSum += wave * weight;
    }

    {
        float weight = 3.5;
        weightSum += weight;
        vec2 uv = p2 * vec2(2.0, 1.4) + vec2(0.0, -p2.x * 2.0);
        uv.x += wavesTime * 0.25;
        float wave = textureSmooth(noisetex, uv).z;
        wavesSum += wave * weight;
    }

    {
        float weight = 7.5;
        weightSum += weight;
        vec2 uv = p3 * vec2(1.1, 0.8) + vec2(0.0, p3.x * 1.1);
        uv.x -= wavesTime * 0.4;
        float wave = textureSmooth(noisetex, uv).x;
        wavesSum += wave * weight;
    }

    {
        float weight = 5.5;
        weightSum += weight;
        vec2 uv = p4 * vec2(1.0, 0.7);
        uv.x += wavesTime * 0.3;
        float wave = textureSmooth(noisetex, uv).y;
        wavesSum += wave * weight;
    }

    float finalWaves = wavesSum / weightSum;

    return finalWaves * amplitude;
}
