#version 460 compatibility

/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/

#include "/Include/Settings.glsl"

uniform sampler2D tex;

in vec4 texcoord;
in vec4 color;
in vec3 normal;
in vec4 lmcoord;

void main() {
    vec4 t = texture(tex, texcoord.st) * color;

    #include "/Include/Debug/WhiteWorld.glsl"

    if (normal.z < 0.0) {
        t.rgb = vec3(0.0);
    }

    gl_FragData[0] = vec4(t.rgb, t.a);
    gl_FragData[1] = vec4(normal * 0.5 + 0.5, 0.0);
}
