#version 460 compatibility

/*
====================================================================================================

    Copyright (C) 2025 Pyvtron VX Shaders - Pyvton

    All Rights Reserved unless otherwise explicitly stated.

    Before You Do Something With Pyvtron VX Shaders, You MUST Read This:

    You Must Read The License: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-license
    And Read The Agreement: https://pyvton.pages.dev/minecraft-shaders/pyvtron-shaders-agreement

====================================================================================================
*/

#include "/Include/Settings.glsl"

uniform vec3 cameraPosition;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;

uniform vec2 taaJitter;

#ifdef DISTANT_HORIZONS
    uniform sampler2D dhDepthTex0;
    uniform sampler2D dhDepthTex1;

    uniform mat4 dhProjection;
    uniform mat4 dhProjectionInverse;
    uniform float dhNearPlane;
    uniform float dhFarPlane;

    #define DH_BLOCK_WATER 8
#endif

#if MC_VERSION >= 11500
layout(location = 11) in vec4 mc_Entity;
#else
layout(location = 10) in vec4 mc_Entity;
#endif

out vec4 color;
out vec4 texcoord;
out vec3 worldNormal;

out vec4 viewPos;
out vec3 worldPosition;

out vec2 blockLight;

out float iswater;
out float isice;
out float isStainedGlass;
out float materialIDs;

void main() {
    viewPos = gl_ModelViewMatrix * gl_Vertex;
    gl_Position = gl_ProjectionMatrix * viewPos;

    #include "/Include/SphericalWorld.glsl"

    #ifdef TAA
        #include "/Include/AntiAliasing/TAA.glsl"
    #endif

    worldPosition.xyz = mat3(gbufferModelViewInverse) * viewPos.xyz + cameraPosition.xyz;

    color = gl_Color;
    texcoord = gl_MultiTexCoord0;
    worldNormal = gl_Normal;

    vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
    blockLight.x = clamp((lmcoord.x * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);
    blockLight.y = clamp((lmcoord.y * 33.05 / 32.0) - 1.05 / 32.0, 0.0, 1.0);

    iswater = 0.0;
    isice = 0.0;
    isStainedGlass = 1.0;
    materialIDs = 7;

#ifdef DISTANT_HORIZONS
    if (dhMaterialId == DH_BLOCK_WATER) {
        iswater = 1.0;
        isStainedGlass = 0.0;
        materialIDs = 6;
    } else if (dhMaterialId == 79) {
        isice = 1.0;
        isStainedGlass = 0.0;
        materialIDs = 8;
    }
#else
    if (mc_Entity.x == 8) {
        iswater = 1.0;
        isStainedGlass = 0.0;
        materialIDs = 6;
    }
    if (mc_Entity.x == 79) {
        isice = 1.0;
        isStainedGlass = 0.0;
        materialIDs = 8;
    }
#endif
}
 