/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client;

import de.maxhenkel.voicechat.api.audiochannel.ClientAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.ClientStaticAudioChannel;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.Mth;
import ru.dimaskama.voicemessages.VoiceMessagesPlugin;

public class Playback {
    private static final ScheduledExecutorService SOUND_PLAYER_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "VoiceMessagesPlayer"));
    private final ClientAudioChannel channel;
    private final List<short[]> audio;
    private final FloatList audioLevels;
    private final AtomicInteger framePosition = new AtomicInteger();
    private volatile ScheduledFuture<?> playFuture;
    private volatile Runnable onFinish;

    public Playback(List<short[]> audio) {
        this(audio, Playback.calculateAudioLevels(audio));
    }

    public Playback(List<short[]> audio, FloatList audioLevels) {
        this(Playback.createChannel(), audio, audioLevels);
    }

    public Playback(ClientAudioChannel channel, List<short[]> audio, FloatList audioLevels) {
        this.channel = channel;
        this.audio = audio;
        this.audioLevels = audioLevels;
    }

    private static ClientAudioChannel createChannel() {
        ClientStaticAudioChannel channel = VoiceMessagesPlugin.getClientApi().createStaticAudioChannel(UUID.randomUUID());
        channel.setCategory(VoiceMessagesPlugin.getVolumeCategory().getId());
        return channel;
    }

    public ClientAudioChannel getChannel() {
        return this.channel;
    }

    public List<short[]> getAudio() {
        return this.audio;
    }

    public FloatList getAudioLevels() {
        return this.audioLevels;
    }

    public int getFramePosition() {
        return this.framePosition.get();
    }

    public int getDurationMs() {
        return 1000 * this.audio.size() / 50;
    }

    public float getProgress() {
        return (float)this.framePosition.get() / (float)this.audio.size();
    }

    public void setProgress(float progress) {
        this.framePosition.set(Math.round(progress * (float)this.audio.size()));
    }

    public synchronized boolean isPlaying() {
        return this.playFuture != null && !this.playFuture.isDone();
    }

    public synchronized void play() {
        if (this.getProgress() >= 1.0f) {
            this.setProgress(0.0f);
        }
        if (this.playFuture == null || this.playFuture.isDone()) {
            this.playFuture = SOUND_PLAYER_EXECUTOR.scheduleAtFixedRate(this::playNextFrame, 0L, 20L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.playFuture != null) {
            this.playFuture.cancel(true);
        }
    }

    public void setOnFinish(Runnable onFinish) {
        this.onFinish = onFinish;
    }

    private void playNextFrame() {
        int pos = this.framePosition.getAndIncrement();
        if (pos < 0 || pos >= this.audio.size()) {
            Runnable onFinish = this.onFinish;
            if (onFinish != null) {
                onFinish.run();
            }
            throw new RuntimeException("playback finished");
        }
        this.channel.play(this.audio.get(pos));
    }

    public static float calculateAudioLevel(short[] frame) {
        float rms = 0.0f;
        for (short value : frame) {
            float sample = (float)value / 32767.0f;
            rms += sample * sample;
        }
        int sampleCount = frame.length / 2;
        rms = sampleCount == 0 ? 0.0f : (float)Math.sqrt(rms / (float)sampleCount);
        float db = rms > 0.0f ? Math.min(Math.max(20.0f * (float)Math.log10(rms), -127.0f), 0.0f) : -127.0f;
        return Mth.clamp((float)Mth.inverseLerp((float)db, (float)-40.0f, (float)-15.0f), (float)0.0f, (float)0.999f);
    }

    public static FloatList calculateAudioLevels(List<short[]> audio) {
        FloatArrayList levels = new FloatArrayList(audio.size());
        for (short[] shorts : audio) {
            levels.add(Playback.calculateAudioLevel(shorts));
        }
        return levels;
    }
}

