/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2f;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.render.PlaybackRenderer;

public class PlaybackPlayer {
    private static final int PLAY_BUTTON_SIDE = 10;
    private static final ResourceLocation PLAY_TEXTURE = VoiceMessagesMod.id("play");
    private static final ResourceLocation PAUSE_TEXTURE = VoiceMessagesMod.id("pause");
    private final PlaybackManager playbackManager;
    private final Playback playback;
    private final int backgroundColor;
    private final String totalDurationString;
    private ScreenRectangle playButtonRectangle = new ScreenRectangle(0, 0, 0, 0);
    private ScreenRectangle playbackTimeRectangle = new ScreenRectangle(0, 0, 0, 0);
    private ScreenRectangle playbackRectangle = new ScreenRectangle(0, 0, 0, 0);
    private int alpha = 255;
    private int overlayColor = -1;

    public PlaybackPlayer(PlaybackManager playbackManager, Playback playback, int backgroundColor) {
        this.playbackManager = playbackManager;
        this.playback = playback;
        this.backgroundColor = backgroundColor;
        this.totalDurationString = "/" + PlaybackPlayer.formatTime(playback.getDurationMs());
    }

    public static String formatTime(int ms) {
        int s = ms / 1000;
        int m = s / 60;
        int sMod = s % 60;
        return String.format("%d:%02d", m, sMod);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.overlayColor = ARGB.color((int)alpha, (int)0xFFFFFF);
    }

    public PlaybackPlayer setRectangle(int x, int y, int width, int height) {
        this.playButtonRectangle = new ScreenRectangle(x, y + (height - 10 >> 1), 10, 10);
        int playbackX = x + Math.min(width, 13);
        this.playbackTimeRectangle = new ScreenRectangle(playbackX, y, x + width - playbackX, height);
        this.playbackRectangle = new ScreenRectangle(0, 0, 0, 0);
        return this;
    }

    public void transform(Matrix3x2f matrix) {
        this.playButtonRectangle = this.playButtonRectangle.transformAxisAligned(matrix);
        this.playbackTimeRectangle = this.playbackTimeRectangle.transformAxisAligned(matrix);
        this.playbackRectangle = this.playbackRectangle.transformAxisAligned(matrix);
    }

    public void render(GuiGraphics guiGraphics) {
        this.renderPlayButton(guiGraphics);
        this.renderPlayback(guiGraphics);
    }

    private void renderPlayButton(GuiGraphics guiGraphics) {
        ResourceLocation id = this.playback.isPlaying() ? PAUSE_TEXTURE : PLAY_TEXTURE;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, id, this.playButtonRectangle.left(), this.playButtonRectangle.top(), this.playButtonRectangle.width(), this.playButtonRectangle.height(), this.overlayColor);
    }

    private void renderPlayback(GuiGraphics guiGraphics) {
        boolean renderTimeStr;
        String timeStr = this.getTimeString();
        Font font = Minecraft.getInstance().font;
        int timeStrWidth = font.width(timeStr);
        int playbackWidth = this.playbackTimeRectangle.width() - timeStrWidth - 5;
        boolean bl = renderTimeStr = playbackWidth >= 5;
        if (!renderTimeStr) {
            playbackWidth = this.playbackTimeRectangle.width();
        }
        if (playbackWidth >= 5) {
            int playbackX = this.playbackTimeRectangle.left();
            int playbackY = this.playbackTimeRectangle.top();
            int playbackHeight = this.playbackTimeRectangle.height();
            this.playbackRectangle = new ScreenRectangle(playbackX, playbackY, playbackWidth, playbackHeight);
            if ((this.backgroundColor & 0xFF000000) != 0) {
                guiGraphics.fill(playbackX - 1, playbackY - 1, playbackX + playbackWidth + 1, playbackY + playbackHeight + 1, -1);
                guiGraphics.fill(playbackX, playbackY, playbackX + playbackWidth, playbackY + playbackHeight, this.backgroundColor);
            }
            PlaybackRenderer.renderPlayback(guiGraphics, playbackX, playbackY, playbackWidth, playbackHeight, this.alpha, this.playback);
        } else {
            this.playbackRectangle = new ScreenRectangle(0, 0, 0, 0);
        }
        if (renderTimeStr) {
            guiGraphics.drawString(font, timeStr, this.playbackTimeRectangle.right() - timeStrWidth, this.playbackTimeRectangle.top() + (this.playbackTimeRectangle.height() - 8 >> 1), this.overlayColor);
        }
    }

    private String getTimeString() {
        return PlaybackPlayer.formatTime(1000 * this.playback.getFramePosition() / 50) + this.totalDurationString;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            float delta;
            if (this.playbackRectangle.containsPoint(mouseX, mouseY) && (delta = Mth.inverseLerp((float)mouseX, (float)this.playbackRectangle.left(), (float)this.playbackRectangle.right())) >= 0.0f && delta <= 1.0f) {
                this.playback.setProgress(delta);
                this.playbackManager.play(this.playback);
                return true;
            }
            if (this.playButtonRectangle.containsPoint(mouseX, mouseY)) {
                if (this.playback.isPlaying()) {
                    this.playbackManager.stopPlaying();
                } else {
                    this.playbackManager.play(this.playback);
                }
                return true;
            }
        }
        return false;
    }
}

