/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3x2f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.client.GuiMessageTagHack;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.PlaybackPlayer;
import ru.dimaskama.voicemessages.client.screen.OverlayScreen;
import ru.dimaskama.voicemessages.duck.client.ChatComponentDuck;

@Mixin(value={ChatComponent.class})
abstract class ChatComponentMixin
implements ChatComponentDuck {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private List<PlaybackPlayer> voicemessages_visiblePlaybackPlayers;

    ChatComponentMixin() {
    }

    @Shadow
    public abstract int getWidth();

    @Shadow
    protected abstract int getLineHeight();

    @Shadow
    public abstract double getScale();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ModifyReturnValue(method={"isChatFocused"}, at={@At(value="TAIL")})
    private boolean modifyChatFocused(boolean original) {
        if (!VoiceMessagesMod.isActive()) return false;
        if (original) return true;
        Screen screen = this.minecraft.screen;
        if (!(screen instanceof OverlayScreen)) return false;
        OverlayScreen overlayScreen = (OverlayScreen)screen;
        if (!(overlayScreen.parent instanceof ChatScreen)) return false;
        return true;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void renderHead(GuiGraphics guiGraphics, int currentTick, int mouseX, int mouseY, boolean focused, CallbackInfo ci) {
        if (VoiceMessagesMod.isActive()) {
            if (this.voicemessages_visiblePlaybackPlayers == null) {
                this.voicemessages_visiblePlaybackPlayers = new ArrayList<PlaybackPlayer>();
            } else {
                this.voicemessages_visiblePlaybackPlayers.clear();
            }
        }
    }

    @WrapOperation(method={"/method_71991|lambda\\$render\\$1/"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;III)V")})
    private void wrapRenderLine(GuiGraphics instance, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int color, Operation<Void> original, @Local(argsOnly=true) GuiMessage.Line line) {
        double scale;
        Playback playback;
        original.call(new Object[]{instance, font, formattedCharSequence, x, y, color});
        if (VoiceMessagesMod.isActive() && (playback = GuiMessageTagHack.getPlayback(line)) != null && (scale = this.getScale()) >= 0.1) {
            int addX = font.width(formattedCharSequence);
            if (addX > 0) {
                addX += 4;
            }
            int lineHeight = this.getLineHeight();
            int playerX = x + addX;
            int playerY = y - (lineHeight - 8 >> 1);
            int playerWidth = (int)((double)this.getWidth() / scale) - addX - x;
            int playerHeight = lineHeight;
            PlaybackPlayer player = new PlaybackPlayer(PlaybackManager.MAIN, playback, 0).setRectangle(playerX, playerY, playerWidth, playerHeight);
            player.setAlpha(ARGB.alpha((int)color));
            player.render(instance);
            player.transform((Matrix3x2f)instance.pose());
            this.voicemessages_visiblePlaybackPlayers.add(player);
        }
    }

    @ModifyExpressionValue(method={"addMessageToDisplayQueue"}, at={@At(value="INVOKE", target="Ljava/util/List;remove(I)Ljava/lang/Object;")})
    private Object clearRemovedMessage(Object original) {
        if (VoiceMessagesMod.isActive()) {
            Playback playback = GuiMessageTagHack.getPlayback((GuiMessage.Line)original);
            if (playback != null) {
                PlaybackManager.MAIN.remove(playback);
            }
            return original;
        }
        return original;
    }

    @Inject(method={"clearMessages"}, at={@At(value="HEAD")})
    private void clearHead(CallbackInfo ci) {
        if (VoiceMessagesMod.isActive()) {
            PlaybackManager.MAIN.clearAll();
        }
    }

    @Override
    public List<PlaybackPlayer> voicemessages_getVisiblePlaybackPlayers() {
        return this.voicemessages_visiblePlaybackPlayers;
    }
}

