/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client.screen;

import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.VoiceMessagesPlugin;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.PlaybackPlayer;
import ru.dimaskama.voicemessages.client.screen.OverlayScreen;
import ru.dimaskama.voicemessages.client.screen.RecordVoiceMessageScreen;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndC2S;

public class VoiceMessageConfirmScreen
extends OverlayScreen {
    private static final WidgetSprites SEND_SPRITES = new WidgetSprites(VoiceMessagesMod.id("send"), VoiceMessagesMod.id("send_hovered"));
    private final int leftX;
    private final int fromBottomY;
    private final Playback playback;
    private final String target;
    @Nullable
    private final Component targetText;
    private int targetTextX;
    private int targetTextY;
    private PlaybackPlayer playbackPlayer;

    public VoiceMessageConfirmScreen(Screen parent, int leftX, int fromBottomY, List<short[]> audio, String target) {
        super((Component)Component.translatable((String)"voicemessages.confirm"), parent);
        this.leftX = leftX;
        this.fromBottomY = fromBottomY;
        this.playback = new Playback(audio);
        this.target = target;
        this.targetText = VoiceMessageConfirmScreen.getScreenTargetText(target);
    }

    @Override
    protected void init() {
        super.init();
        int bottomY = this.height - this.fromBottomY;
        if (this.playbackPlayer == null) {
            this.playbackPlayer = new PlaybackPlayer(PlaybackManager.MAIN, this.playback, -5592406);
            this.playbackPlayer.setRectangle(this.leftX + 1, bottomY - 15, 260, 15);
        }
        ImageButton sendButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftX + 265, bottomY - 15, 14, 14, SEND_SPRITES, button -> {
            this.send();
            this.onClose();
        }));
        sendButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"voicemessages.send")));
        ImageButton cancelButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftX + 281, bottomY - 15, 14, 14, RecordVoiceMessageScreen.CANCEL_SPRITES, button -> this.onClose()));
        cancelButton.setTooltip(Tooltip.create((Component)CommonComponents.GUI_CANCEL));
        this.targetTextX = this.leftX + 300;
        this.targetTextY = bottomY - 12;
    }

    private void send() {
        List<short[]> audio = this.playback.getAudio();
        OpusEncoder encoder = VoiceMessagesPlugin.getClientOpusEncoder();
        encoder.resetState();
        VoiceMessagesModService service = VoiceMessagesMod.getService();
        for (VoiceMessageChunkC2S chunk : VoiceMessageChunkC2S.split(VoiceMessagesPlugin.encodeList(encoder, audio))) {
            service.sendToServer(chunk);
        }
        service.sendToServer(new VoiceMessageEndC2S(this.target));
        VoiceMessages.getLogger().info("Sent voice message (" + 1000 * audio.size() / 50 + "ms)");
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    protected void actualRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 150.0f);
        super.actualRender(guiGraphics, mouseX, mouseY, delta);
        this.playbackPlayer.render(guiGraphics);
        if (this.targetText != null) {
            guiGraphics.drawString(this.font, this.targetText, this.targetTextX, this.targetTextY, -1);
        }
        guiGraphics.pose().popPose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.send();
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.playbackPlayer.mouseClicked((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void removed() {
        super.removed();
        PlaybackManager.MAIN.stopPlaying();
        PlaybackManager.MAIN.remove(this.playback);
    }

    public static Component getTargetText(String target) {
        String key = "voicemessages.target." + target;
        return Component.literal((String)(I18n.exists((String)key) ? I18n.get((String)key, (Object[])new Object[0]) : target));
    }

    @Nullable
    public static Component getScreenTargetText(String target) {
        return "all".equals(target) ? null : Component.translatable((String)"voicemessages.to", (Object[])new Object[]{VoiceMessageConfirmScreen.getTargetText(target)});
    }
}

