/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import ru.dimaskama.voicemessages.api.VoiceMessagesApi;
import ru.dimaskama.voicemessages.networking.VoiceMessagesServerNetworking;

public record VoiceMessagesApiImpl(MinecraftServer server) implements VoiceMessagesApi
{
    @Override
    public boolean isPlayerHasCompatibleModVersion(UUID playerUuid) {
        return VoiceMessagesServerNetworking.hasCompatibleVersion(playerUuid);
    }

    @Override
    public boolean updateAvailableTargets(UUID playerUuid) {
        ServerPlayer player;
        if (VoiceMessagesServerNetworking.hasCompatibleVersion(playerUuid) && (player = this.server.getPlayerList().getPlayer(playerUuid)) != null) {
            VoiceMessagesServerNetworking.updateTargets(player);
            return true;
        }
        return false;
    }

    @Override
    public void sendVoiceMessage(UUID senderUuid, Iterable<UUID> playerUuids, List<byte[]> message, String displayTarget) {
        PlayerList playerList = this.server.getPlayerList();
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        for (UUID playerUuid : playerUuids) {
            ServerPlayer player = playerList.getPlayer(playerUuid);
            if (player == null) continue;
            players.add(player);
        }
        VoiceMessagesServerNetworking.sendVoiceMessage(senderUuid, players, message, displayTarget);
    }
}

