/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.mixin.client;

import java.util.List;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.client.PlaybackPlayer;
import ru.dimaskama.voicemessages.client.networking.VoiceMessagesClientNetworking;
import ru.dimaskama.voicemessages.client.screen.RecordVoiceMessageScreen;
import ru.dimaskama.voicemessages.client.screen.VoiceMessageConfirmScreen;
import ru.dimaskama.voicemessages.duck.client.ChatComponentDuck;

@Mixin(value={ChatScreen.class})
abstract class ChatScreenMixin
extends Screen {
    @Shadow
    protected EditBox input;
    @Unique
    private static final WidgetSprites voicemessages_WIDGET_SPRITES = new WidgetSprites(VoiceMessagesMod.id("microphone"), VoiceMessagesMod.id("microphone_disabled"), VoiceMessagesMod.id("microphone_hovered"));
    @Unique
    private boolean voicemessages_canSendVoiceMessages;
    @Unique
    private ImageButton voicemessages_button;

    private ChatScreenMixin() {
        super(null);
        throw new AssertionError();
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void initTail(CallbackInfo ci) {
        if (VoiceMessagesMod.isActive()) {
            String target;
            List<String> availableTargets = VoiceMessagesClientNetworking.getAvailableTargets();
            this.voicemessages_canSendVoiceMessages = false;
            if (!availableTargets.isEmpty()) {
                target = availableTargets.getFirst();
                if (this.minecraft.getConnection().getPlayerInfo(target) == null) {
                    this.voicemessages_canSendVoiceMessages = true;
                }
            } else {
                target = null;
            }
            if (this.voicemessages_canSendVoiceMessages) {
                int x = this.input.getX();
                int y = this.input.getY();
                this.voicemessages_button = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(x - 3, y - 3, 14, 14, voicemessages_WIDGET_SPRITES, button -> this.minecraft.setScreen((Screen)new RecordVoiceMessageScreen(this, button.getX(), this.height - button.getY() + 1, target))));
                if (this.minecraft.screen == this) {
                    this.voicemessages_button.setTooltip(Tooltip.create((Component)("all".equals(target) ? Component.translatable((String)"voicemessages.voice_message") : Component.translatable((String)"voicemessages.voice_message_to", (Object[])new Object[]{VoiceMessageConfirmScreen.getTargetText(target)}))));
                } else {
                    this.voicemessages_button.active = false;
                }
                this.input.setWidth(this.input.getWidth() - 14);
                this.input.setX(x + 14);
            }
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClickedHead(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (VoiceMessagesMod.isActive()) {
            for (PlaybackPlayer player : ((ChatComponentDuck)this.minecraft.gui.getChat()).voicemessages_getVisiblePlaybackPlayers()) {
                if (!player.mouseClicked((int)mouseX, (int)mouseY, button)) continue;
                cir.setReturnValue((Object)true);
                return;
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void renderHead(CallbackInfo ci) {
        if (VoiceMessagesMod.isActive() && this.getFocused() == this.voicemessages_button) {
            this.setFocused((GuiEventListener)this.input);
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=0)
    private int modifyChatFieldBackgroundX(int x1) {
        if (VoiceMessagesMod.isActive()) {
            return this.voicemessages_canSendVoiceMessages ? x1 + 14 : x1;
        }
        return x1;
    }
}

