/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client.networking;

import com.mojang.util.UndashedUuid;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesPlugin;
import ru.dimaskama.voicemessages.client.GuiMessageTagHack;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageTargetsS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesConfigS2C;

public final class VoiceMessagesClientNetworking {
    private static final Map<UUID, VoiceMessageBuilder> VOICE_MESSAGE_BUILDERS = new ConcurrentHashMap<UUID, VoiceMessageBuilder>();
    private static List<String> availableTargets = List.of();
    private static int maxVoiceMessageDurationMs = 300000;
    private static int maxVoiceMessageFrames = 15000;

    public static void onConfigReceived(VoiceMessagesConfigS2C config) {
        VoiceMessages.getLogger().info("Received voice messages config");
        maxVoiceMessageDurationMs = config.maxVoiceMessageDurationMs();
        maxVoiceMessageFrames = maxVoiceMessageDurationMs * 50 / 1000;
    }

    public static void onTargetsReceived(VoiceMessageTargetsS2C targets) {
        availableTargets = targets.targets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVoiceMessageChunkReceived(VoiceMessageChunkS2C chunk) {
        VoiceMessageBuilder builder;
        UUID senderUuid = chunk.sender();
        VoiceMessageBuilder voiceMessageBuilder = builder = VOICE_MESSAGE_BUILDERS.computeIfAbsent(senderUuid, VoiceMessageBuilder::new);
        synchronized (voiceMessageBuilder) {
            try {
                builder.appendChunk(chunk.encodedAudio());
            }
            catch (Exception e) {
                VoiceMessages.getLogger().warn("Failed to decode voice message chunk", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVoiceMessageEndReceived(VoiceMessageEndS2C end) {
        UUID senderUuid = end.sender();
        String target = end.target();
        VoiceMessageBuilder builder = VOICE_MESSAGE_BUILDERS.remove(senderUuid);
        if (builder != null) {
            VoiceMessageBuilder voiceMessageBuilder = builder;
            synchronized (voiceMessageBuilder) {
                int duration = builder.getDuration();
                List<short[]> audio = builder.getFrames();
                class_310 minecraft = class_310.method_1551();
                minecraft.execute(() -> {
                    class_5250 text;
                    class_640 sender = minecraft.method_1562().method_2871(senderUuid);
                    if (sender != null) {
                        text = sender.method_2971();
                        if (text == null) {
                            text = class_2561.method_43470((String)sender.method_2966().getName());
                        }
                        VoiceMessages.getLogger().info("(Client) Received voice message (" + duration + "ms) from " + sender.method_2966().getName());
                    } else {
                        text = class_2561.method_43473();
                        VoiceMessages.getLogger().info("(Client) Received voice message (" + duration + "ms) from unknown player (" + UndashedUuid.toString((UUID)senderUuid) + ")");
                    }
                    if (!"all".equals(target)) {
                        class_5250 targetName = null;
                        if ("team".equals(target)) {
                            targetName = class_2561.method_43471((String)"voicemessages.target.team");
                        } else {
                            class_640 playerInfo = minecraft.method_1562().method_2874(target);
                            if (playerInfo != null) {
                                targetName = playerInfo.method_2971();
                            }
                            if (targetName == null) {
                                targetName = class_2561.method_43470((String)target);
                            }
                        }
                        text = class_2561.method_43473().method_10852((class_2561)text).method_27693(" \u2192 ").method_10852((class_2561)targetName);
                    }
                    minecraft.field_1705.method_1743().method_44811((class_2561)text, null, GuiMessageTagHack.createAndAdd(audio));
                });
                builder.close();
            }
        } else {
            VoiceMessages.getLogger().warn("Received voice message end packet without previous chunks");
        }
    }

    public static void tickBuildingVoiceMessages() {
        VOICE_MESSAGE_BUILDERS.values().removeIf(b -> {
            VoiceMessageBuilder voiceMessageBuilder = b;
            synchronized (voiceMessageBuilder) {
                int timeSinceStarted = b.getTimeSinceStarted();
                if ((long)timeSinceStarted > 5000L) {
                    VoiceMessages.getLogger().warn("Voice message from " + String.valueOf(b.sender) + " is transfering longer than 5000ms. Cleaning up");
                    b.close();
                    return true;
                }
            }
            return false;
        });
    }

    public static List<String> getAvailableTargets() {
        return availableTargets;
    }

    public static int getMaxVoiceMessageDurationMs() {
        return maxVoiceMessageDurationMs;
    }

    public static int getMaxVoiceMessageFrames() {
        return maxVoiceMessageFrames;
    }

    public static void resetConfig() {
        availableTargets = List.of();
        maxVoiceMessageDurationMs = 300000;
        maxVoiceMessageFrames = 15000;
    }

    private static class VoiceMessageBuilder
    implements AutoCloseable {
        private final long startTime = System.currentTimeMillis();
        private final List<short[]> frames = new ArrayList<short[]>();
        private final OpusDecoder opusDecoder = VoiceMessagesPlugin.getClientApi().createDecoder();
        private final UUID sender;

        private VoiceMessageBuilder(UUID sender) {
            this.sender = sender;
        }

        public void appendChunk(List<byte[]> chunk) {
            this.frames.addAll(VoiceMessagesPlugin.decodeList(this.opusDecoder, chunk));
        }

        public int getDuration() {
            return this.frames.size() * 1000 / 50;
        }

        public int getTimeSinceStarted() {
            return (int)(System.currentTimeMillis() - this.startTime);
        }

        public List<short[]> getFrames() {
            return this.frames;
        }

        @Override
        public void close() {
            this.opusDecoder.close();
        }
    }
}

