/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.networking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.scores.PlayerTeam;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.VoiceMessagesUtil;
import ru.dimaskama.voicemessages.api.ModifyAvailableTargetsCallback;
import ru.dimaskama.voicemessages.api.VoiceMessageReceivedCallback;
import ru.dimaskama.voicemessages.config.Punishment;
import ru.dimaskama.voicemessages.config.ServerConfig;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageTargetsS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesConfigS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesVersionC2S;

public final class VoiceMessagesServerNetworking {
    private static final Set<UUID> HAS_COMPATIBLE_VERSION = Sets.newConcurrentHashSet();
    private static final ListMultimap<UUID, String> AVAILABLE_TARGETS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private static final Map<UUID, Long> VOICE_MESSAGES_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, VoiceMessageBuilder> VOICE_MESSAGE_BUILDERS = new ConcurrentHashMap<UUID, VoiceMessageBuilder>();

    public static void onVoiceMessagesVersionReceived(ServerPlayer sender, VoiceMessagesVersionC2S version) {
        if (VoiceMessages.isClientVersionCompatible(version.modVersion())) {
            if (HAS_COMPATIBLE_VERSION.add(sender.getUUID())) {
                VoiceMessagesModService service = VoiceMessagesMod.getService();
                ServerConfig config = VoiceMessages.SERVER_CONFIG.getData();
                service.sendToPlayer(sender, new VoiceMessagesConfigS2C(config.maxVoiceMessageDurationMs()));
                VoiceMessagesServerNetworking.updateTargets(sender.getServer());
            } else {
                VoiceMessages.getLogger().warn(sender.getGameProfile().getName() + " sent his voicemessages modVersion multiple times");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVoiceMessageChunkReceived(ServerPlayer sender, VoiceMessageChunkC2S chunk) {
        VoiceMessageBuilder builder;
        if (!VoiceMessagesServerNetworking.hasCompatibleVersion(sender)) {
            VoiceMessages.getLogger().warn(sender.getGameProfile().getName() + " sent voice message chunk without compatible VoiceMessages modVersion");
            return;
        }
        if (!VoiceMessagesMod.getService().hasVoiceMessageSendPermission(sender)) {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn(sender.getGameProfile().getName() + " sent voice message chunk without voicemessages.send permission. Punishment: " + punishment.asString());
            switch (punishment) {
                case KICK: {
                    sender.connection.disconnect((Component)Component.translatable((String)"voicemessages.kick.permission_violated"));
                }
                case PREVENT: {
                    return;
                }
            }
        }
        VoiceMessageBuilder voiceMessageBuilder = builder = VOICE_MESSAGE_BUILDERS.computeIfAbsent(sender.getUUID(), VoiceMessageBuilder::new);
        synchronized (voiceMessageBuilder) {
            if (!builder.discarded) {
                builder.appendChunk(chunk.encodedAudio());
                int duration = builder.getDuration();
                int maxDuration = VoiceMessages.SERVER_CONFIG.getData().maxVoiceMessageDurationMs();
                if (duration > maxDuration) {
                    Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
                    VoiceMessages.getLogger().warn("Building voice message exceeds the max duration of " + maxDuration + "ms. Punishment: " + punishment.asString());
                    switch (punishment) {
                        case KICK: {
                            sender.connection.disconnect((Component)Component.translatable((String)"voicemessages.kick.invalid"));
                        }
                        case PREVENT: {
                            builder.discarded = true;
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVoiceMessageEndReceived(ServerPlayer sender, VoiceMessageEndC2S end) {
        VoiceMessageBuilder builder = VOICE_MESSAGE_BUILDERS.remove(sender.getUUID());
        if (builder != null) {
            VoiceMessageBuilder voiceMessageBuilder = builder;
            synchronized (voiceMessageBuilder) {
                if (!builder.discarded) {
                    int timePassed;
                    int duration = builder.getDuration();
                    VoiceMessages.getLogger().info("Received voice message (" + duration + "ms) from " + sender.getGameProfile().getName());
                    long currentTime = System.currentTimeMillis();
                    Long lastTime = VOICE_MESSAGES_TIMES.put(sender.getUUID(), currentTime);
                    if (lastTime != null && duration - (timePassed = (int)(currentTime - lastTime)) > 100) {
                        Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageSpamPunishment();
                        VoiceMessages.getLogger().warn("Received voice message with duration (" + duration + "ms) greater than time passed from previous voice message (" + timePassed + "ms). Punishment:" + punishment.asString());
                        switch (punishment) {
                            case KICK: {
                                sender.connection.disconnect((Component)Component.translatable((String)"voicemessages.kick.spam"));
                            }
                            case PREVENT: {
                                return;
                            }
                        }
                    }
                    VoiceMessagesServerNetworking.sendVoiceMessage(sender, builder.getFrames(), end.target());
                }
            }
        } else {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn("Received voice message end packet without previous chunks from " + sender.getGameProfile().getName() + ". Punishment: " + punishment.asString());
            if (punishment == Punishment.KICK) {
                sender.connection.disconnect((Component)Component.translatable((String)"voicemessages.kick.invalid"));
            }
        }
    }

    public static void sendVoiceMessage(ServerPlayer sender, List<byte[]> message, String target) {
        UUID senderUuid = sender.getUUID();
        if (!AVAILABLE_TARGETS.containsEntry((Object)senderUuid, (Object)target)) {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn(sender.getGameProfile().getName() + " sent voice message with unknown target. Punishment: " + punishment.asString());
            switch (punishment) {
                case KICK: {
                    sender.connection.disconnect((Component)Component.translatable((String)"voicemessages.kick.unknown_target"));
                }
                case PREVENT: {
                    return;
                }
            }
        }
        if (!VoiceMessageReceivedCallback.EVENT.invoker().onVoiceMessageReceived(sender, message, target)) {
            VoiceMessagesServerNetworking.sendVoiceMessage(senderUuid, VoiceMessagesServerNetworking.collectPlayers(sender, target), message, target);
        }
    }

    private static Iterable<ServerPlayer> collectPlayers(ServerPlayer sender, String target) {
        if ("all".equals(target)) {
            return List.copyOf(sender.getServer().getPlayerList().getPlayers());
        }
        if ("team".equals(target)) {
            PlayerTeam team = sender.getTeam();
            if (team != null) {
                PlayerList playerList = sender.getServer().getPlayerList();
                ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
                for (String playerUuidStr : team.getPlayers()) {
                    ServerPlayer player = playerList.getPlayer(UUID.fromString(playerUuidStr));
                    if (player == null) continue;
                    players.add(player);
                }
                return players;
            }
            return List.of(sender);
        }
        ServerPlayer otherPlayer = sender.getServer().getPlayerList().getPlayerByName(target);
        if (otherPlayer != null && !sender.equals((Object)otherPlayer)) {
            return List.of(sender, otherPlayer);
        }
        return List.of(sender);
    }

    public static void sendVoiceMessage(UUID senderUuid, Iterable<ServerPlayer> players, List<byte[]> message, String displayTarget) {
        List<VoiceMessageChunkS2C> chunks = VoiceMessagesUtil.splitToChunks(message, 1024000, ch -> new VoiceMessageChunkS2C(senderUuid, (List<byte[]>)ch));
        VoiceMessageEndS2C end = new VoiceMessageEndS2C(senderUuid, displayTarget);
        VoiceMessagesModService service = VoiceMessagesMod.getService();
        for (ServerPlayer player : players) {
            if (!VoiceMessagesServerNetworking.hasCompatibleVersion(player)) continue;
            for (VoiceMessageChunkS2C chunk : chunks) {
                service.sendToPlayer(player, chunk);
            }
            service.sendToPlayer(player, end);
        }
    }

    public static void tickBuildingVoiceMessages() {
        VOICE_MESSAGE_BUILDERS.values().removeIf(b -> {
            int timeSinceStarted = b.getTimeSinceStarted();
            if ((long)timeSinceStarted > 4000L) {
                VoiceMessages.getLogger().warn("Voice message from " + String.valueOf(b.sender) + " is transfering longer than 4000ms. Cleaning up");
                return true;
            }
            return false;
        });
    }

    public static boolean hasCompatibleVersion(ServerPlayer player) {
        return VoiceMessagesServerNetworking.hasCompatibleVersion(player.getUUID());
    }

    public static boolean hasCompatibleVersion(UUID playerUuid) {
        return HAS_COMPATIBLE_VERSION.contains(playerUuid);
    }

    public static void updateTargets(MinecraftServer server) {
        PlayerList playerList = server.getPlayerList();
        for (UUID p : HAS_COMPATIBLE_VERSION) {
            ServerPlayer player = playerList.getPlayer(p);
            if (player == null) continue;
            VoiceMessagesServerNetworking.updateTargets(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTargets(ServerPlayer player) {
        List targets;
        VoiceMessagesModService service = VoiceMessagesMod.getService();
        List list = targets = AVAILABLE_TARGETS.get((Object)player.getUUID());
        synchronized (list) {
            targets.clear();
            if (service.hasVoiceMessageSendPermission(player)) {
                if (service.hasVoiceMessageSendAllPermission(player)) {
                    targets.add("all");
                }
                if (service.hasVoiceMessageSendTeamPermission(player)) {
                    targets.add("team");
                }
                if (service.hasVoiceMessageSendPlayersPermission(player)) {
                    PlayerList playerList = player.getServer().getPlayerList();
                    for (UUID playerUuid : HAS_COMPATIBLE_VERSION) {
                        ServerPlayer p = playerList.getPlayer(playerUuid);
                        if (p == null) continue;
                        targets.add(p.getGameProfile().getName());
                    }
                }
                ModifyAvailableTargetsCallback.EVENT.invoker().modifyAvailableTargets(player, targets);
            }
            service.sendToPlayer(player, new VoiceMessageTargetsS2C(List.copyOf(targets)));
        }
    }

    public static void onPlayerDisconnected(MinecraftServer server, UUID playerUuid) {
        AVAILABLE_TARGETS.removeAll((Object)playerUuid);
        if (HAS_COMPATIBLE_VERSION.remove(playerUuid)) {
            VoiceMessagesServerNetworking.updateTargets(server);
        }
    }

    private static class VoiceMessageBuilder {
        private final long startTime = System.currentTimeMillis();
        private final List<byte[]> frames = new ArrayList<byte[]>();
        private final UUID sender;
        public boolean discarded;

        private VoiceMessageBuilder(UUID sender) {
            this.sender = sender;
        }

        public void appendChunk(List<byte[]> chunk) {
            this.frames.addAll(chunk);
        }

        public int getDuration() {
            return this.frames.size() * 1000 / 50;
        }

        public int getTimeSinceStarted() {
            return (int)(System.currentTimeMillis() - this.startTime);
        }

        public List<byte[]> getFrames() {
            return this.frames;
        }
    }
}

