/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_310;
import ru.dimaskama.voicemessages.client.Playback;

public class PlaybackManager {
    public static final PlaybackManager MAIN = new PlaybackManager();
    private final Map<UUID, Playback> playbacks = new HashMap<UUID, Playback>();
    private Playback lastInChat;
    private Playback playingNow;

    private PlaybackManager() {
    }

    public void stopPlaying() {
        if (this.playingNow != null && this.playingNow.isPlaying()) {
            this.playingNow.stop();
            this.playingNow = null;
        }
    }

    public Playback get(UUID uuid) {
        return this.playbacks.get(uuid);
    }

    public UUID addFromChat(List<short[]> audio) {
        Playback playback = new Playback(audio);
        this.addFromChat(playback);
        return playback.getChannel().getId();
    }

    public void addFromChat(Playback playback) {
        if (this.lastInChat != null) {
            this.lastInChat.setOnFinish(() -> class_310.method_1551().execute(() -> {
                playback.setProgress(0.0f);
                this.play(playback);
            }));
        }
        this.lastInChat = playback;
        this.add(playback);
    }

    public void add(Playback playback) {
        this.playbacks.put(playback.getChannel().getId(), playback);
    }

    public void remove(Playback playback) {
        this.playbacks.remove(playback.getChannel().getId());
    }

    public void play(Playback playback) {
        if (this.playingNow != playback || !playback.isPlaying()) {
            this.add(playback);
            this.stopPlaying();
            playback.play();
            this.playingNow = playback;
        }
    }

    public void clearAll() {
        this.stopPlaying();
        this.playbacks.clear();
    }
}

