/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.networking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.VoiceMessagesUtil;
import ru.dimaskama.voicemessages.api.ModifyAvailableTargetsCallback;
import ru.dimaskama.voicemessages.api.VoiceMessageReceivedCallback;
import ru.dimaskama.voicemessages.config.Punishment;
import ru.dimaskama.voicemessages.config.ServerConfig;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageTargetsS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesConfigS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesVersionC2S;

public final class VoiceMessagesServerNetworking {
    private static final Set<UUID> HAS_COMPATIBLE_VERSION = Sets.newConcurrentHashSet();
    private static final ListMultimap<UUID, String> AVAILABLE_TARGETS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private static final Map<UUID, Long> VOICE_MESSAGES_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, VoiceMessageBuilder> VOICE_MESSAGE_BUILDERS = new ConcurrentHashMap<UUID, VoiceMessageBuilder>();

    public static void onVoiceMessagesVersionReceived(class_3222 sender, VoiceMessagesVersionC2S version) {
        if (VoiceMessages.isClientVersionCompatible(version.modVersion())) {
            if (HAS_COMPATIBLE_VERSION.add(sender.method_5667())) {
                VoiceMessagesModService service = VoiceMessagesMod.getService();
                ServerConfig config = VoiceMessages.SERVER_CONFIG.getData();
                service.sendToPlayer(sender, new VoiceMessagesConfigS2C(config.maxVoiceMessageDurationMs()));
                VoiceMessagesServerNetworking.updateTargets(sender.field_13995);
            } else {
                VoiceMessages.getLogger().warn(sender.method_7334().getName() + " sent his voicemessages modVersion multiple times");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVoiceMessageChunkReceived(class_3222 sender, VoiceMessageChunkC2S chunk) {
        VoiceMessageBuilder builder;
        if (!VoiceMessagesServerNetworking.hasCompatibleVersion(sender)) {
            VoiceMessages.getLogger().warn(sender.method_7334().getName() + " sent voice message chunk without compatible VoiceMessages modVersion");
            return;
        }
        if (!VoiceMessagesMod.getService().hasVoiceMessageSendPermission(sender)) {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn(sender.method_7334().getName() + " sent voice message chunk without voicemessages.send permission. Punishment: " + punishment.asString());
            switch (punishment) {
                case KICK: {
                    sender.field_13987.method_52396((class_2561)class_2561.method_43471((String)"voicemessages.kick.permission_violated"));
                }
                case PREVENT: {
                    return;
                }
            }
        }
        VoiceMessageBuilder voiceMessageBuilder = builder = VOICE_MESSAGE_BUILDERS.computeIfAbsent(sender.method_5667(), VoiceMessageBuilder::new);
        synchronized (voiceMessageBuilder) {
            if (!builder.discarded) {
                builder.appendChunk(chunk.encodedAudio());
                int duration = builder.getDuration();
                int maxDuration = VoiceMessages.SERVER_CONFIG.getData().maxVoiceMessageDurationMs();
                if (duration > maxDuration) {
                    Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
                    VoiceMessages.getLogger().warn("Building voice message exceeds the max duration of " + maxDuration + "ms. Punishment: " + punishment.asString());
                    switch (punishment) {
                        case KICK: {
                            sender.field_13987.method_52396((class_2561)class_2561.method_43471((String)"voicemessages.kick.invalid"));
                        }
                        case PREVENT: {
                            builder.discarded = true;
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVoiceMessageEndReceived(class_3222 sender, VoiceMessageEndC2S end) {
        VoiceMessageBuilder builder = VOICE_MESSAGE_BUILDERS.remove(sender.method_5667());
        if (builder != null) {
            VoiceMessageBuilder voiceMessageBuilder = builder;
            synchronized (voiceMessageBuilder) {
                if (!builder.discarded) {
                    int timePassed;
                    int duration = builder.getDuration();
                    VoiceMessages.getLogger().info("Received voice message (" + duration + "ms) from " + sender.method_7334().getName());
                    long currentTime = System.currentTimeMillis();
                    Long lastTime = VOICE_MESSAGES_TIMES.put(sender.method_5667(), currentTime);
                    if (lastTime != null && duration - (timePassed = (int)(currentTime - lastTime)) > 100) {
                        Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageSpamPunishment();
                        VoiceMessages.getLogger().warn("Received voice message with duration (" + duration + "ms) greater than time passed from previous voice message (" + timePassed + "ms). Punishment:" + punishment.asString());
                        switch (punishment) {
                            case KICK: {
                                sender.field_13987.method_52396((class_2561)class_2561.method_43471((String)"voicemessages.kick.spam"));
                            }
                            case PREVENT: {
                                return;
                            }
                        }
                    }
                    VoiceMessagesServerNetworking.sendVoiceMessage(sender, builder.getFrames(), end.target());
                }
            }
        } else {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn("Received voice message end packet without previous chunks from " + sender.method_7334().getName() + ". Punishment: " + punishment.asString());
            if (punishment == Punishment.KICK) {
                sender.field_13987.method_52396((class_2561)class_2561.method_43471((String)"voicemessages.kick.invalid"));
            }
        }
    }

    public static void sendVoiceMessage(class_3222 sender, List<byte[]> message, String target) {
        UUID senderUuid = sender.method_5667();
        if (!AVAILABLE_TARGETS.containsEntry((Object)senderUuid, (Object)target)) {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn(sender.method_7334().getName() + " sent voice message with unknown target. Punishment: " + punishment.asString());
            switch (punishment) {
                case KICK: {
                    sender.field_13987.method_52396((class_2561)class_2561.method_43471((String)"voicemessages.kick.unknown_target"));
                }
                case PREVENT: {
                    return;
                }
            }
        }
        if (!VoiceMessageReceivedCallback.EVENT.invoker().onVoiceMessageReceived(sender, message, target)) {
            VoiceMessagesServerNetworking.sendVoiceMessage(senderUuid, VoiceMessagesServerNetworking.collectPlayers(sender, target), message, target);
        }
    }

    private static Iterable<class_3222> collectPlayers(class_3222 sender, String target) {
        if ("all".equals(target)) {
            return List.copyOf(sender.field_13995.method_3760().method_14571());
        }
        if ("team".equals(target)) {
            class_268 team = sender.method_5781();
            if (team != null) {
                class_3324 playerList = sender.field_13995.method_3760();
                ArrayList<class_3222> players = new ArrayList<class_3222>();
                for (String playerUuidStr : team.method_1204()) {
                    class_3222 player = playerList.method_14602(UUID.fromString(playerUuidStr));
                    if (player == null) continue;
                    players.add(player);
                }
                return players;
            }
            return List.of(sender);
        }
        class_3222 otherPlayer = sender.field_13995.method_3760().method_14566(target);
        if (otherPlayer != null && !sender.equals((Object)otherPlayer)) {
            return List.of(sender, otherPlayer);
        }
        return List.of(sender);
    }

    public static void sendVoiceMessage(UUID senderUuid, Iterable<class_3222> players, List<byte[]> message, String displayTarget) {
        List<VoiceMessageChunkS2C> chunks = VoiceMessagesUtil.splitToChunks(message, 1024000, ch -> new VoiceMessageChunkS2C(senderUuid, (List<byte[]>)ch));
        VoiceMessageEndS2C end = new VoiceMessageEndS2C(senderUuid, displayTarget);
        VoiceMessagesModService service = VoiceMessagesMod.getService();
        for (class_3222 player : players) {
            if (!VoiceMessagesServerNetworking.hasCompatibleVersion(player)) continue;
            for (VoiceMessageChunkS2C chunk : chunks) {
                service.sendToPlayer(player, chunk);
            }
            service.sendToPlayer(player, end);
        }
    }

    public static void tickBuildingVoiceMessages() {
        VOICE_MESSAGE_BUILDERS.values().removeIf(b -> {
            int timeSinceStarted = b.getTimeSinceStarted();
            if ((long)timeSinceStarted > 4000L) {
                VoiceMessages.getLogger().warn("Voice message from " + String.valueOf(b.sender) + " is transfering longer than 4000ms. Cleaning up");
                return true;
            }
            return false;
        });
    }

    public static boolean hasCompatibleVersion(class_3222 player) {
        return VoiceMessagesServerNetworking.hasCompatibleVersion(player.method_5667());
    }

    public static boolean hasCompatibleVersion(UUID playerUuid) {
        return HAS_COMPATIBLE_VERSION.contains(playerUuid);
    }

    public static void updateTargets(MinecraftServer server) {
        class_3324 playerList = server.method_3760();
        for (UUID p : HAS_COMPATIBLE_VERSION) {
            class_3222 player = playerList.method_14602(p);
            if (player == null) continue;
            VoiceMessagesServerNetworking.updateTargets(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTargets(class_3222 player) {
        List targets;
        VoiceMessagesModService service = VoiceMessagesMod.getService();
        List list = targets = AVAILABLE_TARGETS.get((Object)player.method_5667());
        synchronized (list) {
            targets.clear();
            if (service.hasVoiceMessageSendPermission(player)) {
                if (service.hasVoiceMessageSendAllPermission(player)) {
                    targets.add("all");
                }
                if (service.hasVoiceMessageSendTeamPermission(player)) {
                    targets.add("team");
                }
                if (service.hasVoiceMessageSendPlayersPermission(player)) {
                    class_3324 playerList = player.field_13995.method_3760();
                    for (UUID playerUuid : HAS_COMPATIBLE_VERSION) {
                        class_3222 p = playerList.method_14602(playerUuid);
                        if (p == null) continue;
                        targets.add(p.method_7334().getName());
                    }
                }
                ModifyAvailableTargetsCallback.EVENT.invoker().modifyAvailableTargets(player, targets);
            }
            service.sendToPlayer(player, new VoiceMessageTargetsS2C(List.copyOf(targets)));
        }
    }

    public static void onPlayerDisconnected(MinecraftServer server, UUID playerUuid) {
        AVAILABLE_TARGETS.removeAll((Object)playerUuid);
        if (HAS_COMPATIBLE_VERSION.remove(playerUuid)) {
            VoiceMessagesServerNetworking.updateTargets(server);
        }
    }

    private static class VoiceMessageBuilder {
        private final long startTime = System.currentTimeMillis();
        private final List<byte[]> frames = new ArrayList<byte[]>();
        private final UUID sender;
        public boolean discarded;

        private VoiceMessageBuilder(UUID sender) {
            this.sender = sender;
        }

        public void appendChunk(List<byte[]> chunk) {
            this.frames.addAll(chunk);
        }

        public int getDuration() {
            return this.frames.size() * 1000 / 50;
        }

        public int getTimeSinceStarted() {
            return (int)(System.currentTimeMillis() - this.startTime);
        }

        public List<byte[]> getFrames() {
            return this.frames;
        }
    }
}

