/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.paper.networking;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import ru.dimaskama.voicemessages.paper.VoiceMessagesPaper;
import ru.dimaskama.voicemessages.paper.networking.PacketUtils;

public record VoiceMessageTargetsS2C(List<String> targets) {
    public static final String CHANNEL = VoiceMessagesPaper.id("targets");

    public byte[] encode() {
        int packetSize = PacketUtils.getVarIntSize(this.targets.size());
        ArrayList<byte[]> encodedTargets = new ArrayList<byte[]>();
        for (String target : this.targets) {
            byte[] encodedTarget = target.getBytes(StandardCharsets.UTF_8);
            packetSize += PacketUtils.getVarIntSize(encodedTarget.length) + encodedTarget.length;
            encodedTargets.add(encodedTarget);
        }
        byte[] bytes = new byte[packetSize];
        int pos = 0;
        pos += PacketUtils.writeVarInt(bytes, pos, encodedTargets.size());
        for (byte[] encodedTarget : encodedTargets) {
            pos += PacketUtils.writeVarInt(bytes, pos, encodedTarget.length);
            System.arraycopy(encodedTarget, 0, bytes, pos, encodedTarget.length);
            pos += encodedTarget.length;
        }
        return bytes;
    }
}

