/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.paper.networking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesUtil;
import ru.dimaskama.voicemessages.api.ModifyAvailableTargetsCallback;
import ru.dimaskama.voicemessages.api.VoiceMessageReceivedCallback;
import ru.dimaskama.voicemessages.config.Punishment;
import ru.dimaskama.voicemessages.paper.VoiceMessagesPaper;
import ru.dimaskama.voicemessages.paper.networking.PacketUtils;
import ru.dimaskama.voicemessages.paper.networking.VoiceMessageTargetsS2C;
import ru.dimaskama.voicemessages.paper.networking.VoiceMessagesConfigS2C;

public final class VoiceMessagesPaperNetworking {
    public static final String VOICE_MESSAGES_VERSION_C2S = VoiceMessagesPaper.id("version");
    public static final String VOICE_MESSAGE_CHUNK_S2C_CHANNEL = VoiceMessagesPaper.id("voice_message_chunk_s2c");
    public static final String VOICE_MESSAGE_END_S2C_CHANNEL = VoiceMessagesPaper.id("voice_message_end_s2c");
    public static final String VOICE_MESSAGE_CHUNK_C2S_CHANNEL = VoiceMessagesPaper.id("voice_message_chunk_c2s");
    public static final String VOICE_MESSAGE_END_C2S_CHANNEL = VoiceMessagesPaper.id("voice_message_end_c2s");
    private static final Set<UUID> HAS_COMPATIBLE_VERSION = Sets.newConcurrentHashSet();
    private static final ListMultimap<UUID, String> AVAILABLE_TARGETS = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private static final Map<UUID, Long> VOICE_MESSAGES_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, VoiceMessageBuilder> VOICE_MESSAGE_BUILDERS = new ConcurrentHashMap<UUID, VoiceMessageBuilder>();

    public static void init(Plugin plugin) {
        Bukkit.getMessenger().registerIncomingPluginChannel(plugin, VOICE_MESSAGES_VERSION_C2S, (channel, player, message) -> VoiceMessagesPaperNetworking.onVoiceMessagesVersionReceived(player, message));
        Bukkit.getMessenger().registerOutgoingPluginChannel(plugin, VoiceMessagesConfigS2C.CHANNEL);
        Bukkit.getMessenger().registerOutgoingPluginChannel(plugin, VoiceMessageTargetsS2C.CHANNEL);
        Bukkit.getMessenger().registerIncomingPluginChannel(plugin, VOICE_MESSAGE_CHUNK_C2S_CHANNEL, (channel, player, message) -> VoiceMessagesPaperNetworking.onVoiceMessageChunkReceived(player, message));
        Bukkit.getMessenger().registerIncomingPluginChannel(plugin, VOICE_MESSAGE_END_C2S_CHANNEL, (channel, player, message) -> VoiceMessagesPaperNetworking.onVoiceMessageEndReceived(player, message));
        Bukkit.getMessenger().registerOutgoingPluginChannel(plugin, VOICE_MESSAGE_CHUNK_S2C_CHANNEL);
        Bukkit.getMessenger().registerOutgoingPluginChannel(plugin, VOICE_MESSAGE_END_S2C_CHANNEL);
    }

    public static void sendConfig(Player player, VoiceMessagesConfigS2C config) {
        player.sendPluginMessage((Plugin)VoiceMessagesPaper.getInstance(), VoiceMessagesConfigS2C.CHANNEL, config.encode());
    }

    public static void updateTargets() {
        for (UUID playerUuid : HAS_COMPATIBLE_VERSION) {
            Player player = Bukkit.getPlayer((UUID)playerUuid);
            if (player == null) continue;
            VoiceMessagesPaperNetworking.updateTargets(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTargets(Player player) {
        List targets;
        List list = targets = AVAILABLE_TARGETS.get((Object)player.getUniqueId());
        synchronized (list) {
            targets.clear();
            if (player.hasPermission("voicemessages.send")) {
                if (player.hasPermission("voicemessages.send.all")) {
                    targets.add("all");
                }
                if (player.hasPermission("voicemessages.send.team")) {
                    targets.add("team");
                }
                if (player.hasPermission("voicemessages.send.players")) {
                    Server server = player.getServer();
                    for (UUID playerUuid : HAS_COMPATIBLE_VERSION) {
                        Player p = server.getPlayer(playerUuid);
                        if (p == null) continue;
                        targets.add(p.getName());
                    }
                }
                ModifyAvailableTargetsCallback.EVENT.invoker().modifyAvailableTargets(player, targets);
            }
            player.sendPluginMessage((Plugin)VoiceMessagesPaper.getInstance(), VoiceMessageTargetsS2C.CHANNEL, new VoiceMessageTargetsS2C(List.copyOf(targets)).encode());
        }
    }

    private static void onVoiceMessagesVersionReceived(Player player, byte[] message) {
        String version = (String)PacketUtils.readUtf8(message, 0).getFirst();
        if (VoiceMessages.isClientVersionCompatible(version)) {
            if (HAS_COMPATIBLE_VERSION.add(player.getUniqueId())) {
                VoiceMessagesPaperNetworking.addChannelsToPlayerWithReflection(player);
                VoiceMessagesPaperNetworking.sendConfig(player, new VoiceMessagesConfigS2C(VoiceMessages.SERVER_CONFIG.getData().maxVoiceMessageDurationMs()));
                VoiceMessagesPaperNetworking.updateTargets();
            } else {
                VoiceMessages.getLogger().warn(player.getName() + " sent his voicemessages mod version multiple times");
            }
        }
    }

    private static void addChannelsToPlayerWithReflection(Player player) {
        try {
            Class<?> craftPlayer = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".entity.CraftPlayer");
            Method addChannel = craftPlayer.getMethod("addChannel", String.class);
            Set alreadyAdded = player.getListeningPluginChannels();
            if (!alreadyAdded.contains(VoiceMessagesConfigS2C.CHANNEL)) {
                addChannel.invoke((Object)player, VoiceMessagesConfigS2C.CHANNEL);
            }
            if (!alreadyAdded.contains(VoiceMessageTargetsS2C.CHANNEL)) {
                addChannel.invoke((Object)player, VoiceMessageTargetsS2C.CHANNEL);
            }
            if (!alreadyAdded.contains(VOICE_MESSAGE_CHUNK_S2C_CHANNEL)) {
                addChannel.invoke((Object)player, VOICE_MESSAGE_CHUNK_S2C_CHANNEL);
            }
            if (!alreadyAdded.contains(VOICE_MESSAGE_END_S2C_CHANNEL)) {
                addChannel.invoke((Object)player, VOICE_MESSAGE_END_S2C_CHANNEL);
            }
        }
        catch (Exception e) {
            VoiceMessages.getLogger().error("Failed to add plugin channels with reflection. Voice Messages may work broken!", e);
        }
    }

    public static boolean hasCompatibleVersion(Player player) {
        return VoiceMessagesPaperNetworking.hasCompatibleVersion(player.getUniqueId());
    }

    public static boolean hasCompatibleVersion(UUID playerUuid) {
        return HAS_COMPATIBLE_VERSION.contains(playerUuid);
    }

    public static void onPlayerDisconnected(Player player) {
        AVAILABLE_TARGETS.removeAll((Object)player.getUniqueId());
        if (HAS_COMPATIBLE_VERSION.remove(player.getUniqueId())) {
            VoiceMessagesPaperNetworking.updateTargets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onVoiceMessageChunkReceived(Player sender, byte[] message) {
        VoiceMessageBuilder builder;
        if (!VoiceMessagesPaperNetworking.hasCompatibleVersion(sender)) {
            VoiceMessages.getLogger().warn(sender.getName() + " sent voice message chunk without compatible VoiceMessages modVersion");
            return;
        }
        if (!sender.hasPermission("voicemessages.send")) {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn(sender.getName() + " sent voice message chunk without voicemessages.send permission. Punishment: " + punishment.asString());
            switch (punishment) {
                case KICK: {
                    sender.kick((Component)Component.text((String)"Voice messages permission is violated"));
                }
                case PREVENT: {
                    return;
                }
            }
        }
        List voiceMessage = (List)PacketUtils.readVoiceMessage(message, 0).getFirst();
        VoiceMessageBuilder voiceMessageBuilder = builder = VOICE_MESSAGE_BUILDERS.computeIfAbsent(sender.getUniqueId(), VoiceMessageBuilder::new);
        synchronized (voiceMessageBuilder) {
            if (!builder.discarded) {
                builder.appendChunk(voiceMessage);
                int duration = builder.getDuration();
                int maxDuration = VoiceMessages.SERVER_CONFIG.getData().maxVoiceMessageDurationMs();
                if (duration > maxDuration) {
                    Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
                    VoiceMessages.getLogger().warn("Building voice message exceeds the max duration of " + maxDuration + "ms. Punishment: " + punishment.asString());
                    switch (punishment) {
                        case KICK: {
                            sender.kick((Component)Component.text((String)"You sent an invalid voice message"));
                        }
                        case PREVENT: {
                            builder.discarded = true;
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onVoiceMessageEndReceived(Player sender, byte[] end) {
        VoiceMessageBuilder builder = VOICE_MESSAGE_BUILDERS.remove(sender.getUniqueId());
        if (builder != null) {
            String target = (String)PacketUtils.readUtf8(end, 0).getFirst();
            VoiceMessageBuilder voiceMessageBuilder = builder;
            synchronized (voiceMessageBuilder) {
                if (!builder.discarded) {
                    int timePassed;
                    int duration = builder.getDuration();
                    VoiceMessages.getLogger().info("Received voice message (" + duration + "ms) from " + sender.getName());
                    long currentTime = System.currentTimeMillis();
                    Long lastTime = VOICE_MESSAGES_TIMES.put(sender.getUniqueId(), currentTime);
                    if (lastTime != null && duration - (timePassed = (int)(currentTime - lastTime)) > 100) {
                        Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageSpamPunishment();
                        VoiceMessages.getLogger().warn("Received voice message with duration (" + duration + "ms) greater than time passed from previous voice message (" + timePassed + "ms). Punishment:" + punishment.asString());
                        switch (punishment) {
                            case KICK: {
                                sender.kick((Component)Component.text((String)"The length of the sent voice message is longer than the time elapsed since the previous one"));
                            }
                            case PREVENT: {
                                return;
                            }
                        }
                    }
                    VoiceMessagesPaperNetworking.sendVoiceMessage(sender, builder.getFrames(), target);
                }
            }
        } else {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn("Received voice message end packet without previous chunks from " + sender.getName() + ". Punishment: " + punishment.asString());
            if (punishment == Punishment.KICK) {
                sender.kick((Component)Component.text((String)"You sent an invalid voice message"));
            }
        }
    }

    public static void sendVoiceMessage(Player sender, List<byte[]> message, String target) {
        UUID senderUuid = sender.getUniqueId();
        if (!AVAILABLE_TARGETS.containsEntry((Object)senderUuid, (Object)target)) {
            Punishment punishment = VoiceMessages.SERVER_CONFIG.getData().voiceMessageInvalidPunishment();
            VoiceMessages.getLogger().warn(sender.getName() + " sent voice message with unknown target. Punishment: " + punishment.asString());
            switch (punishment) {
                case KICK: {
                    sender.kick((Component)Component.text((String)"Unknown voice message target"));
                }
                case PREVENT: {
                    return;
                }
            }
        }
        if (!VoiceMessageReceivedCallback.EVENT.invoker().onVoiceMessageReceived(sender, message, target)) {
            VoiceMessagesPaperNetworking.sendVoiceMessage(senderUuid, VoiceMessagesPaperNetworking.collectPlayers(sender, target), message, target);
        }
    }

    private static Iterable<Player> collectPlayers(Player sender, String target) {
        Server server = sender.getServer();
        if ("all".equals(target)) {
            return List.copyOf(server.getOnlinePlayers());
        }
        if ("team".equals(target)) {
            Team team = sender.getScoreboard().getEntryTeam(sender.getUniqueId().toString());
            if (team != null) {
                ArrayList<Player> players = new ArrayList<Player>();
                for (String playerUuidStr : team.getEntries()) {
                    Player player = server.getPlayer(UUID.fromString(playerUuidStr));
                    if (player == null) continue;
                    players.add(player);
                }
                return players;
            }
            return List.of(sender);
        }
        Player otherPlayer = server.getPlayer(target);
        if (otherPlayer != null && !sender.equals((Object)otherPlayer)) {
            return List.of(sender, otherPlayer);
        }
        return List.of(sender);
    }

    public static void sendVoiceMessage(UUID senderUuid, Iterable<Player> players, List<byte[]> message, String displayTarget) {
        List<byte[]> chunks = VoiceMessagesUtil.splitToChunks(message, 1024000, ch -> {
            byte[] bytes = new byte[16 + PacketUtils.getVoiceMessageSize(ch)];
            PacketUtils.writeUuid(bytes, 0, senderUuid);
            PacketUtils.writeVoiceMessage(bytes, 16, ch);
            return bytes;
        });
        byte[] encodedTarget = displayTarget.getBytes(StandardCharsets.UTF_8);
        byte[] end = new byte[16 + PacketUtils.getVarIntSize(encodedTarget.length) + encodedTarget.length];
        PacketUtils.writeUuid(end, 0, senderUuid);
        int pos = 16;
        pos += PacketUtils.writeVarInt(end, pos, encodedTarget.length);
        System.arraycopy(encodedTarget, 0, end, pos, encodedTarget.length);
        VoiceMessagesPaper plugin = VoiceMessagesPaper.getInstance();
        for (Player player : players) {
            if (!VoiceMessagesPaperNetworking.hasCompatibleVersion(player)) continue;
            for (byte[] chunk : chunks) {
                player.sendPluginMessage((Plugin)plugin, VOICE_MESSAGE_CHUNK_S2C_CHANNEL, chunk);
            }
            player.sendPluginMessage((Plugin)plugin, VOICE_MESSAGE_END_S2C_CHANNEL, end);
        }
    }

    public static void tickBuildingVoiceMessages() {
        VOICE_MESSAGE_BUILDERS.values().removeIf(b -> {
            int timeSinceStarted = b.getTimeSinceStarted();
            if ((long)timeSinceStarted > 4000L) {
                VoiceMessages.getLogger().warn("Voice message from " + String.valueOf(b.sender) + " is transfering longer than 4000ms. Cleaning up");
                return true;
            }
            return false;
        });
    }

    private static class VoiceMessageBuilder {
        private final long startTime = System.currentTimeMillis();
        private final List<byte[]> frames = new ArrayList<byte[]>();
        private final UUID sender;
        public boolean discarded;

        private VoiceMessageBuilder(UUID sender) {
            this.sender = sender;
        }

        public void appendChunk(List<byte[]> chunk) {
            this.frames.addAll(chunk);
        }

        public int getDuration() {
            return this.frames.size() * 1000 / 50;
        }

        public int getTimeSinceStarted() {
            return (int)(System.currentTimeMillis() - this.startTime);
        }

        public List<byte[]> getFrames() {
            return this.frames;
        }
    }
}

