/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.paper;

import java.util.logging.Logger;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.api.VoiceMessagesApiInitCallback;
import ru.dimaskama.voicemessages.logger.AbstractLogger;
import ru.dimaskama.voicemessages.paper.VoiceMessagesPaperListener;
import ru.dimaskama.voicemessages.paper.impl.VoiceMessagesApiImpl;
import ru.dimaskama.voicemessages.paper.networking.VoiceMessagesPaperNetworking;

public final class VoiceMessagesPaper
extends JavaPlugin {
    private static VoiceMessagesPaper instance;

    public void onEnable() {
        instance = this;
        final Logger logger = this.getLogger();
        VoiceMessages.init(this.getPluginMeta().getVersion(), new AbstractLogger(){

            @Override
            public void info(String message) {
                logger.info(message);
            }

            @Override
            public void info(String message, Exception e) {
                logger.info(message);
                logger.info(e.getLocalizedMessage());
            }

            @Override
            public void warn(String message) {
                logger.warning(message);
            }

            @Override
            public void warn(String message, Exception e) {
                logger.warning(message);
                logger.warning(e.getLocalizedMessage());
            }

            @Override
            public void error(String message) {
                logger.severe(message);
            }

            @Override
            public void error(String message, Exception e) {
                logger.severe(message);
                logger.severe(e.getLocalizedMessage());
            }
        });
        this.getServer().getPluginManager().registerEvents((Listener)new VoiceMessagesPaperListener(this), (Plugin)this);
        if (VoiceMessagesPaper.isFolia()) {
            this.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this, t -> VoiceMessagesPaperNetworking.tickBuildingVoiceMessages(), 5L, 5L);
        } else {
            this.getServer().getScheduler().runTaskTimer((Plugin)this, VoiceMessagesPaperNetworking::tickBuildingVoiceMessages, 5L, 5L);
        }
        VoiceMessages.SERVER_CONFIG.loadOrCreate();
        VoiceMessagesPaperNetworking.init((Plugin)this);
        VoiceMessagesApiInitCallback.EVENT.invoker().setVoiceMessagesApi(new VoiceMessagesApiImpl());
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static VoiceMessagesPaper getInstance() {
        return instance;
    }

    public static String id(String path) {
        return "voicemessages:" + path;
    }
}

