/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.paper;

import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.config.ServerConfig;
import ru.dimaskama.voicemessages.paper.VoiceMessagesPaper;
import ru.dimaskama.voicemessages.paper.networking.VoiceMessagesPaperNetworking;

public record VoiceMessagesPaperListener(VoiceMessagesPaper plugin) implements Listener
{
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerUuid = event.getPlayer().getUniqueId();
        Server server = event.getPlayer().getServer();
        Runnable modPresenceCheck = () -> {
            ServerConfig config;
            Player player = server.getPlayer(playerUuid);
            if (player != null && !VoiceMessagesPaperNetworking.hasCompatibleVersion(player) && (config = VoiceMessages.SERVER_CONFIG.getData()).modRequired()) {
                player.kickPlayer(config.modNotInstalledText());
            }
        };
        if (VoiceMessagesPaper.isFolia()) {
            server.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, t -> modPresenceCheck.run(), 15L);
        } else {
            server.getScheduler().runTaskLater((Plugin)this.plugin, modPresenceCheck, 15L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        VoiceMessagesPaperNetworking.onPlayerDisconnected(event.getPlayer());
    }
}

