/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.paper.networking;

import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PacketUtils {
    public static int getVarIntSize(int i) {
        int size = 0;
        while ((i & 0xFFFFFF80) != 0) {
            i >>>= 7;
            ++size;
        }
        return size + 1;
    }

    public static long readVarInt(byte[] bytes, int position) {
        byte b;
        int result = 0;
        int size = 0;
        do {
            b = bytes[position + size];
            result |= (b & 0x7F) << size++ * 7;
            if (size <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return (long)size << 32 | (long)result;
    }

    public static int writeVarInt(byte[] bytes, int position, int i) {
        int size = 0;
        while ((i & 0xFFFFFF80) != 0) {
            bytes[position + size] = (byte)(i & 0x7F | 0x80);
            i >>>= 7;
            ++size;
        }
        bytes[position + size] = (byte)i;
        return size + 1;
    }

    public static int unpackSize(long readVarInt) {
        return (int)(readVarInt >>> 32);
    }

    public static int unpackInt(long readVarInt) {
        return (int)(readVarInt & 0xFFFFFFFFL);
    }

    public static Pair<List<byte[]>, Integer> readVoiceMessage(byte[] bytes, int position) {
        int offset = 0;
        long packedFrameCount = PacketUtils.readVarInt(bytes, position + offset);
        offset += PacketUtils.unpackSize(packedFrameCount);
        int frameCount = PacketUtils.unpackInt(packedFrameCount);
        if (frameCount > 15000) {
            throw new IllegalArgumentException("Frame count is greater than 15000");
        }
        ArrayList<byte[]> frames = new ArrayList<byte[]>(frameCount);
        for (int i = 0; i < frameCount; ++i) {
            long packedFrameSize = PacketUtils.readVarInt(bytes, position + offset);
            int frameSize = PacketUtils.unpackInt(packedFrameSize);
            if (frameSize > 15000) {
                throw new IllegalArgumentException("Frame #" + i + " is larger than 15000 bytes");
            }
            byte[] frame = new byte[frameSize];
            System.arraycopy(bytes, position + (offset += PacketUtils.unpackSize(packedFrameSize)), frame, 0, frameSize);
            frames.add(frame);
            offset += frameSize;
        }
        return Pair.of(frames, (Object)offset);
    }

    public static int getVoiceMessageSize(List<byte[]> audio) {
        int size = PacketUtils.getVarIntSize(audio.size());
        for (byte[] frame : audio) {
            size += PacketUtils.getVarIntSize(frame.length) + frame.length;
        }
        return size;
    }

    public static int writeVoiceMessage(byte[] bytes, int position, List<byte[]> audio) {
        int offset = 0;
        offset += PacketUtils.writeVarInt(bytes, position + offset, audio.size());
        for (byte[] frame : audio) {
            offset += PacketUtils.writeVarInt(bytes, position + offset, frame.length);
            System.arraycopy(frame, 0, bytes, position + offset, frame.length);
            offset += frame.length;
        }
        return offset;
    }

    public static void writeUuid(byte[] bytes, int position, UUID uuid) {
        PacketUtils.writeLong(bytes, position, uuid.getMostSignificantBits());
        PacketUtils.writeLong(bytes, position + 8, uuid.getLeastSignificantBits());
    }

    public static void writeLong(byte[] bytes, int position, long l) {
        for (int i = 0; i < 8; ++i) {
            bytes[position + i] = (byte)(l >>> 56 - (i << 3) & 0xFFL);
        }
    }

    public static Pair<String, Integer> readUtf8(byte[] bytes, int position) {
        long packedSize = PacketUtils.readVarInt(bytes, position);
        int offset = PacketUtils.unpackSize(packedSize);
        int size = PacketUtils.unpackInt(packedSize);
        String string = new String(bytes, offset, size, StandardCharsets.UTF_8);
        return Pair.of((Object)string, (Object)(offset += size));
    }
}

