/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client.screen;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.PlaybackPlayer;
import ru.dimaskama.voicemessages.client.networking.VoiceMessagesClientNetworking;
import ru.dimaskama.voicemessages.client.render.PlaybackRenderer;
import ru.dimaskama.voicemessages.client.screen.OverlayScreen;
import ru.dimaskama.voicemessages.client.screen.VoiceMessageConfirmScreen;

public class RecordVoiceMessageScreen
extends OverlayScreen {
    public static final class_8666 CANCEL_SPRITES = new class_8666(VoiceMessagesMod.id("cancel"), VoiceMessagesMod.id("cancel_hovered"));
    private static final class_8666 DONE_SPRITES = new class_8666(VoiceMessagesMod.id("done"), VoiceMessagesMod.id("done_hovered"));
    private final int leftX;
    private final int fromBottomY;
    private final String target;
    @Nullable
    private final class_2561 targetText;
    private volatile boolean recorded;
    private List<short[]> recordedFrames = new ArrayList<short[]>();
    private FloatList audioLevels = new FloatArrayList();
    private VoiceMessagesModService.VoiceRecordThread recordThread;
    private Exception microphoneException;
    private class_344 doneButton;
    private class_344 cancelButton;

    public RecordVoiceMessageScreen(class_437 parent, int leftX, int fromBottomY, String target) {
        super((class_2561)class_2561.method_43471((String)"voicemessages.recording"), parent);
        this.leftX = leftX;
        this.fromBottomY = fromBottomY;
        this.target = target;
        this.targetText = VoiceMessageConfirmScreen.getScreenTargetText(target);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        PlaybackManager.MAIN.stopPlaying();
        if (!this.recorded && this.recordThread == null) {
            this.recordThread = VoiceMessagesMod.getService().createVoiceRecordThread(this::appendFrame, e -> {
                this.microphoneException = e;
            });
            this.recordThread.startVoiceRecord();
        }
        this.doneButton = (class_344)this.method_37063((class_364)new class_344(14, 14, DONE_SPRITES, button -> {
            this.stopRecording();
            if (this.recorded) {
                this.method_25419();
            }
        }, class_5244.field_39003));
        this.doneButton.method_47400(class_7919.method_47407((class_2561)class_5244.field_24334));
        this.cancelButton = (class_344)this.method_37063((class_364)new class_344(14, 14, CANCEL_SPRITES, button -> this.field_22787.method_1507(this.parent), class_5244.field_39003));
        this.cancelButton.method_47400(class_7919.method_47407((class_2561)class_5244.field_24335));
    }

    private boolean appendFrame(short[] frame) {
        this.recordedFrames.add(frame);
        this.audioLevels.add(Playback.calculateAudioLevel(frame));
        if (this.recordedFrames.size() < VoiceMessagesClientNetworking.getMaxVoiceMessageFrames()) {
            return true;
        }
        this.recordThread = null;
        this.onStoppedRecording();
        return false;
    }

    private void stopRecording() {
        if (this.recordThread != null) {
            this.recordThread.stopVoiceRecord();
            this.recordThread = null;
            this.onStoppedRecording();
        }
    }

    private void onStoppedRecording() {
        this.recordedFrames = Collections.unmodifiableList(this.recordedFrames);
        this.audioLevels = FloatLists.unmodifiable((FloatList)this.audioLevels);
        this.recorded = true;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.microphoneException != null) {
            VoiceMessages.getLogger().warn("Microphone error", this.microphoneException);
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"voicemessages.microphone_error", (Object[])new Object[]{this.microphoneException.getLocalizedMessage()}).method_27692(class_124.field_1061), true);
            this.field_22787.method_1507(null);
        } else if (this.recorded) {
            this.method_25419();
        }
    }

    @Override
    public void method_25419() {
        if (this.recordedFrames.isEmpty()) {
            super.method_25419();
        } else {
            this.field_22787.method_1507((class_437)new VoiceMessageConfirmScreen(this.parent, this.leftX, this.fromBottomY, this.recordedFrames, this.target));
        }
    }

    @Override
    public void method_25432() {
        this.stopRecording();
        super.method_25432();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    @Override
    protected void actualRender(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 150.0f);
        int bottomY = this.field_22790 - this.fromBottomY;
        guiGraphics.method_25294(this.leftX - 1, bottomY - 16, this.leftX + 243, bottomY + 1, -1);
        guiGraphics.method_25294(this.leftX, bottomY - 15, this.leftX + 242, bottomY, -43691);
        int maxFrames = VoiceMessagesClientNetworking.getMaxVoiceMessageFrames();
        float recordProgress = (float)this.recordedFrames.size() / (float)maxFrames;
        PlaybackRenderer.renderPlayback(guiGraphics, this.leftX + 1, bottomY - 15, 240, 15, 255, recordProgress, maxFrames, this.audioLevels);
        int maxDuration = VoiceMessagesClientNetworking.getMaxVoiceMessageDurationMs();
        String timeStr = PlaybackPlayer.formatTime((int)(recordProgress * (float)maxDuration)) + "/" + PlaybackPlayer.formatTime(maxDuration);
        guiGraphics.method_25303(this.field_22793, timeStr, this.leftX + 247, bottomY - 12, -1);
        int timeStrWidth = this.field_22793.method_1727(timeStr);
        this.doneButton.method_48229(this.leftX + 247 + timeStrWidth + 5, bottomY - 15);
        this.cancelButton.method_48229(this.leftX + 247 + timeStrWidth + 21, bottomY - 15);
        if (this.targetText != null) {
            guiGraphics.method_27535(this.field_22793, this.targetText, this.leftX + 247 + timeStrWidth + 40, bottomY - 12, -1);
        }
        super.actualRender(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_51448().method_22909();
    }
}

